/*  names.c - name table management
 *
 *  The name table is a set of strings (with no duplication).
 *  Every lookup of a name will always return the same address,
 *  so looked-up names can be compared by comparing pointers.
 */


#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "../util.h"

#define NBUCKETS 647			/* number of hash bins */


typedef struct namerec {
    char *n_string;
    struct namerec *n_next;
} *Nameptr;

static Nameptr bucket[NBUCKETS];	/* hash table */



/*  nt_lookup(name,install_flag) -- look up name, install if so requested.
 *  return pointer if found or installed, else NULL.
 */

char *
nt_lookup(name,install_flag)
char *name;
Bool install_flag;
{
    register int h;
    char *s;
    register Nameptr p;

    assert(name!=NULL);
    h = 0;
    for (s = name; *s; )
	h += *s++;
    for (p = bucket[h % NBUCKETS]; p; p = p->n_next)
	if (strcmp(name,p->n_string) == 0)
	    return (p->n_string);
    if (install_flag) {
	p = (Nameptr) alloc (sizeof (struct namerec));
	p->n_string = salloc(name);
	p->n_next = bucket[h % NBUCKETS];
	bucket[h % NBUCKETS] = p;
	return (p->n_string);
    }
    return (NULL);
}
