/*  globals.h -- definitions of global variables  */

#ifndef GLOBAL
#define GLOBAL extern
#define INIT(v)
#endif



GLOBAL char dbflags[128];	/* debugging flags */

GLOBAL FILE *cfile;		/* .c output file */
GLOBAL FILE *hfile;		/* .h output file */

GLOBAL FILE *wi_fd INIT(0);	/* .i output file, also used as a flag */



/*  input  */

GLOBAL char *source_file;	/* current source file */
GLOBAL int line_number;		/* line number in source file */
GLOBAL Token tok;		/* current token, set by get_token() */
GLOBAL int lineno;		/* scanner's idea of line number */
GLOBAL char *tk_str;		/* string representation of a token */

GLOBAL int warn_err_cnt;	/* number of warning errors in current file */
GLOBAL int fatal_err_cnt;	/* number of fatal errors in current file */
GLOBAL short do_time_check	/* check that imported objects are current */
       INIT(1);

GLOBAL Nodeptr yynode;		/* for const token (num, char, string, boolean),
				   value node corresponding to yytext */


/*  lex internals used for saving and restoring state  */
/*  (this is dangerous! we hope lex never changes...)  */

extern YYCHAR *yysptr;		/* lex internals that are needed in */
extern YYCHAR yysbuf[];		/* inter.c and parse.c */
extern FILE *yyin;		/* lex input file */

extern YYCHAR yytext[];		/* token string; defined by lex */



/*  parsing  */

GLOBAL Segment segment;		/* current segment type (S_RESOURCE etc.) */
GLOBAL int inter_depth INIT(0); /* depth of recursion for parsing imports */

GLOBAL char * comp_name;	/* name of component being parsed */
GLOBAL Symptr comp_sym;		/* its symbol table entry */
GLOBAL Symptr main_table INIT(NULLSYM);
				/* auxiliary table for spec's declarations */
						
GLOBAL Symptr reply_block;	/* most recent initial, final, proc or input */
GLOBAL Classptr classes INIT(NULLCLASS);	/* class list pointer */

GLOBAL Bool parsing_body;	/* true iff parsing body */
GLOBAL Bool final_done;		/* true if final code been generated */
GLOBAL Bool in_variab_name;	/* see mustbe; kludge for better errmsgs */
 


/* follow sets for parsing */

#define dclinit {TK_END,TK_CONST,TK_OP,TK_SEM,TK_EXTERNAL,TK_VAR,TK_TYPE, \
       TK_INITIAL,TK_FINAL,TK_PROC,TK_PROCESS,TK_SEMICOLON,TK_NOTATOKEN}

#define definit {TK_END,TK_CONST,TK_OP,TK_SEM,TK_EXTERNAL,TK_VAR,TK_TYPE, \
  TK_INITIAL, TK_FINAL,TK_PROC,TK_PROCESS,TK_LEFTBCE,TK_ASSIGN,TK_SEMICOLON, \
  TK_NOTATOKEN}

GLOBAL Token fl_declr_stmt[] INIT(dclinit);
GLOBAL Token fl_def_stmt[] INIT(definit);




/*  Symbol table pointers  */

GLOBAL Symptr st_cb;			/* current block in st */

GLOBAL Symptr accessmode_sym;		/* signature checking for open() */
GLOBAL Symptr seektype_sym;		/* signature checking for seek() */

GLOBAL Local_blockptr lb_top;		/* top of local block list */
GLOBAL Local_blockptr lb_end;		/* end of local block list */



/*  control flow */

GLOBAL int next_label INIT(NOLAB);	/* target of "next" statement */
GLOBAL int exit_label INIT(NOLAB);	/* target of "exit" statement */
GLOBAL int return_label INIT(NOLAB);	/* target of "return" statement */

GLOBAL int curr_label INIT(NOLAB+1);	/* latest label from NEWLAB macro */

GLOBAL Bool unreachable;		/* set after exit, next, or return */



/* code generation stuff */

GLOBAL int cur_proc;			/* current proc number */
GLOBAL int max_offset[MAX_PROC];	/* largest (ie furthest) offset seen */
GLOBAL int res_var_size;		/* size allocated for resource vars */

GLOBAL Bool did_talloc;			/* nonzero if proc called sr_talloc */
