#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"
#include "../srsys.h"

static int
	in_sp = -1,
	in_spsave[MAX_NEST],	/* offset to save sp in for this input */
	in_offset[MAX_NEST];	/* offset that holds invocation block ptr */

static int
	mininv,		/* offset of pointer to minimum cap so far */
	minval;		/* offset of minimum value for sched. exp */

static void reply_stmt();
	
/* set min for scheduling expressions */
void
gen_set_min(exp)
Nodeptr exp;
{
    mininv = temp_alloc(PTRSIZE);
    minval = temp_alloc(INTSIZE);
    cprintf("LO(%d)=%e;\n",minval,exp);
    cprintf("LA(%d)=LA(%d);\n",mininv,in_offset[in_sp]);
}

void
gen_update_min(exp)
Nodeptr exp;
{
    cprintf("if(%e<LO(%d))LO(%d)=%e,LA(%d)=LA(%d);\n",
	exp, minval, minval, exp, mininv, in_offset[in_sp]);
}

void
gen_remove_min()
{
    cprintf("sr_rm_iop(LA(%d)=LA(%d));\n",in_offset[in_sp],mininv);
}


/* generate code to access class cl */
void
gen_access(cl)
Classptr cl;
{
    cprintf("sr_iaccess(A(%C),%d);\n",cl, FALSE);
}

/* generate code to access class cl */
void
gen_elseaccess(cl)
Classptr cl;
{
    cprintf("sr_iaccess(A(%C),%d);\n",cl,TRUE);
}


/* generate code to look at an invocation on the current access list.  */
void
gen_get_inv()
{
    cprintf("LA(%d)=sr_get_anyinv();\n",in_offset[in_sp]);
}

void
gen_get_named_inv(exp)
Nodeptr exp;
{
    cprintf("LA(%d)=sr_get_myinv(*(opcap*)%a);\n",in_offset[in_sp],exp->e_l);
}


void
gen_get_named_inv_nb(flab)
int flab;
{
    cprintf("if(!(LA(%d)=sr_chk_myinv(((invb)LA(%d))->opc)))goto %g;\n",
	in_offset[in_sp], in_offset[in_sp], flab);
}

/* this is an optimization equivalent to doing an access, get_inv, and then
   a remove.  */
void
gen_receive(cl)
Classptr cl;
{
    cprintf("LA(%d)=sr_receive(A(%C));\n",in_offset[in_sp],cl);
}

/* compare the op capability exp with the op_cap field of the latest
   invocation.  If they are different, branch to flabel.  We already
   know that the vm id and sequence number match, or the invocation
   wouldn't be on this list (and old invocations are purged);
   so we just check the op table index.
*/
void
gen_match(exp, flabel)
Nodeptr exp;
int flabel;
{
    cprintf(
    "if(((opcap *)%a)->oper_index!=((invb)LA(%d))->opc.oper_index)goto %g;\n",
         exp->e_l, in_offset[in_sp], flabel);
}

void
gen_elsematch(flabel)
int flabel;
{
    cprintf("if(LA(%d)) goto %g;\n", in_offset[in_sp], flabel);
}


/* tell RTS that we accept the current invocation */
void
gen_remove_inv()
{
    cprintf("sr_rm_iop(LA(%d))\n;",in_offset[in_sp]);
}

void
gen_input_done()
{
    cprintf("sr_finished_input(LA(%d))\n;",in_offset[in_sp]);
}

void
gen_input_begin()
{
    if (++ in_sp == MAX_NEST)
	boom("nesting too deep");
    in_offset[in_sp] = temp_alloc(PTRSIZE);
    in_spsave[in_sp] = temp_alloc(PTRSIZE);
}

void
gen_input_end()
{
    assert(in_spsave[in_sp] >= -1);	/* if it's a semaphore it will be -1 */
    -- in_sp;
}

/* used in icode.c;  provided so that in_offset doesn't need to be global */
int
inoffset()
{
    return (in_offset[in_sp]);
}


/* generate code to do a P() on a semaphore */
void
gen_sem_p(exp)
Nodeptr exp;
{
    in_spsave[++in_sp] = -1;	/* remember that we _haven't_ saved the sp */
    cprintf("P(A(%a));\n",exp->e_l);
}

/* generate code for a reply statement.
 * note: a reply inside the else part of in will have in_sp>=0
 * but might apply to the enclosing proc.
 * gen_reply and reply_stmt are written to account for such.
 */
void
gen_reply(blk)
Symptr blk;
{
    if (! blk) boom("NULL blk in gen_reply");
    if (blk->s_type == T_INIT || blk->s_type == T_FINAL)
	cprintf("sr_reply(0);\n");
    else 
	switch (blk->s_tdef->s_restrict) {
	case R_SEND:
	    break;
	case R_CALL:
	    reply_stmt(blk);
	    break;
	case R_CALLSEND:
	    /* branch past reply code if it was a send.
	     * don't generate code for reply to semaphore op.
	     */
	    if (blk->s_tdef->s_impl == IM_INPUT) {
		assert(in_sp >= 0);
		cprintf("if(((invb)LA(%d))->type!=SEND_IN)\n ",
		    in_offset[in_sp]);
		reply_stmt(blk);
	    } else if (blk->s_tdef->s_impl==IM_PROC
		    || blk->s_tdef->s_impl==IM_PROCESS) {
		cprintf("if(((invb)pb)->type!=SEND_IN)\n ");
		reply_stmt(blk);
	    } else {
		assert(blk->s_tdef->s_impl==IM_SEMAPHORE);
		errmsg(E_WARN,
		       "reply to op invoked only by send has no effect: %s",
		       blk->s_tdef->s_name);
	    }
	    break;
	default:
	    boom("bad op restrictor in gen_reply");
	    /*NOTREACHED*/
	}
}


/* generate actual reply() stmt;
 * code above assumes this gens just one stmt.
 */
static void
reply_stmt(blk)
Symptr blk;
{
    if (blk->s_tdef->s_impl == IM_INPUT) { /* reply from an in-operation */
	assert(in_sp >= 0);
	cprintf("LA(%d)=sr_reply(LA(%d));\n",
	    in_offset[in_sp], in_offset[in_sp]);
    } else {
	assert(blk->s_tdef->s_impl==IM_PROC || blk->s_tdef->s_impl==IM_PROCESS);
	cprintf("pb=sr_reply(pb);\n");
    }
}
