/* block.c -- descriptor mangling and other stuff */

#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"
#include "../srsys.h"

static void desc_ranges(), desc_size(), desc_offset(), rec_type_desc();
static void gen_make_classes(), gen_make_op(), gen_ne_sym();

static Symptr cur_bl[MAX_NEST];		/* keep track of current block */
static int bl_sp;
static Local_blockptr spec_bl;



/* generate prequel to initial code. */
void
gen_init_prequel()
{
    Symptr sym;
    int op_cnt;
    
    /* find the spec  block */
    for (spec_bl = lb_top;
	 spec_bl && spec_bl->l_st->s_type != T_SPEC;
	 spec_bl = spec_bl->l_next)
	;
    assert(spec_bl);

    /* allocate space for resource vars */
    cprintf("rv=sr_alloc_rv(%d);\n",res_var_size);
	
    /* initialize constants */
    init_const(spec_bl->l_st);
	
    /* make semaphores -- note that all semaphores are in the spec and
       none are ever exported.
    */
    for (sym=spec_bl->l_st->s_next; sym; sym=sym->s_next)
	if (sym->s_kind == K_SEMAPHORE)
	    cprintf("A(%A)=sr_make_semop();\n",sym);
    
    /* make classes for all res iops */
    gen_make_classes(spec_bl->l_st->s_tdef->s_next);
    gen_make_classes(spec_bl->l_st->s_next);
	
    /* tell RTS about ops */

    op_cnt = 0;
	
    for (sym = spec_bl->l_st->s_tdef->s_next; sym; sym = sym->s_next)
	if (sym->s_kind == K_OP)
	    gen_make_op(sym,op_cnt++);

    for (sym = spec_bl->l_st->s_next; sym; sym = sym->s_next)
	if (sym->s_kind == K_OP && sym->s_size != SIZE_UNK)
	    gen_make_op(sym,op_cnt++);

    if (op_cnt)
	cprintf("%d);\n",END_OP);
}

void
init_const(spec)
Symptr spec;
{
    Symptr s;
    if (! spec->s_tdef)
	return;
    for (s=spec->s_tdef->s_next; s; s=s->s_next) {
	switch (s->s_kind) {
	case K_CONST:
	    gen_assign(idnode(s), s->s_value);
	    cprintf(";\n");
	    break;
	case K_IMPORT:
	    if (s->s_done != 2) {
		s->s_done = 2;
		init_const(s);
	    }
	    break;
	default:
	    break;
	}
    }
}



/* build a descriptor for a (possibly anonymous) type */
void
build_type_desc(sym)
Symptr sym;
{
    switch (sym->s_type) {
    case T_REC:
    case T_STRING:
	if (! sym->s_dessize) {
	    assert(sym->s_size != SIZE_UNK);
	    return;
	} else {
	    rec_type_desc(sym);
	}
	break;
    default:
	break;
    }
}
    

/* build a descriptor for a var or const.  If dyn_offset == OFF_UNK,
   allocate space on the stack; otherwise dyn_offset is a stack offset
   that contains the offset.
*/
void
build_desc(sym, where, dyn_offset)
Symptr sym;
Alloc_where where;
int dyn_offset;
{
    if ((sym->s_type == T_REC || sym->s_type == T_STRING)
	    && sym->s_tdef->s_kind == K_ANON)
	rec_type_desc(sym->s_tdef);
	
    if (sym->s_ranges)
	desc_ranges(sym);
	
    if (sym->s_size == SIZE_UNK) {
	desc_size(sym);
	desc_offset(sym, where, dyn_offset);
    }
    
    /* if it's a local iop, initialize it. */
	if (sym->s_kind == K_OP && sym->s_impl == IM_INPUT &&
	    (sym->s_segment != S_RESOURCE || sym->s_size == SIZE_UNK)) {
	    if (sym->s_class->cl_segment != S_RESOURCE &&
			sym->s_class->cl_refcnt++ == 0) {
		cprintf("A(%C)=sr_make_class();\n",sym->s_class);
	    }
	    cprintf("sr_make_liop(A(%C),%A,",sym->s_class,sym);
	    gen_ne_sym(sym);
	    cprintf(");\n");
	}
}


/* calculate and store ranges in descriptor */
static void
desc_ranges(sym)
Symptr sym;
{
    assert(sym->s_desoff != OFF_UNK);
    /* fill in bounds for first dimension */
	cprintf("I(%D+%d)=%e;\n",sym,AD_LB1,sym->s_ranges->r_dim1->e_l);
	cprintf("I(%D+%d)=%e;\n",sym,AD_UB1,sym->s_ranges->r_dim1->e_r);
    /* second dimension */
	if (sym->s_ranges->r_dim2) {
	    cprintf("I(%D+%d)=%e;\n",sym,AD_LB2,sym->s_ranges->r_dim2->e_l);
	    cprintf("I(%D+%d)=%e;\n",sym,AD_UB2,sym->s_ranges->r_dim2->e_r);
	}
}


/* put size and offset in descriptor */
static void
desc_size(sym)
Symptr sym;
{
    assert(sym->s_dessize != OFF_UNK);
    cprintf("I(%D+%d)=%Z",sym,AD_SIZE,sym);
    /* calculate number of elements */
    if (sym->s_ranges) {
	cprintf("*(%]-%[+1)",sym,sym);
	if (sym->s_ranges->r_dim2)
	    cprintf("*(%}-%{+1)",sym,sym);
    }
    cprintf(";\n");
}


/* fill in offset field in descriptor */
static void
desc_offset(sym, where, dyn_offset)
Symptr sym;
Alloc_where where;
int dyn_offset;
{
    if (where == Use_fp_offset) {
	/* address or offset */
	cprintf("I(%D+%d)=LO(%d);\n",sym,AD_ADDR,dyn_offset);
	/* update dyn_offset */
	cprintf("LO(%d)+=R(I(%D+%d));\n",dyn_offset,sym,AD_SIZE);
    } else if (where == Use_mem_alloc) {
	cprintf("A(%D+%d)=sr_gen_alloc(%*,%d);\n",sym,AD_ADDR,sym,PROG_OWN);
    } else {
	assert(where == Use_stack);
	cprintf("A(%&)=sr_talloc(R(%*),&memlist);\n",sym,sym);
	did_talloc = TRUE;
    }
}


/* build a descriptor for a record type */    
static void
rec_type_desc(sym)
Symptr sym;
{
    int sz, offoff;
    Symptr s;
    
    if (sym->s_size != SIZE_UNK)
	return;
    assert(sym->s_dessize && sym->s_desoff != OFF_UNK);
    
    /* figure out static size of type */
    sz = 0;
    for (s=sym->s_tdef->s_next; s; s=s->s_next) {
	if (s->s_offset != OFF_UNK)
	    sz = s->s_offset + s->s_size;
    }
    
    offoff = temp_alloc(INTSIZE);
    cprintf("LO(%d)=%d;\n",offoff,align(sz));
    
    /* fill in descriptors for record fields */
    for (s=sym->s_tdef->s_next; s; s=s->s_next) {
	if (s->s_dessize) {
	    build_desc(s, Use_fp_offset, offoff);
	}
    }
    
    /* fill in size of sym */
    cprintf("I(%D+%d)=LO(%d);\n",sym,AD_SIZE,offoff);
    temp_free(INTSIZE);
}


/* generate code to make classes for the list of symbols beginning with sym */
/* this gets called to make resource-level classes */
static void
gen_make_classes(sym)
Symptr sym;
{
    for (; sym; sym=sym->s_next)
	if (	sym->s_kind == K_OP && 
		sym->s_impl == IM_INPUT && 
		sym->s_class->cl_refcnt++ == 0)
	    cprintf("A(%C)=sr_make_class();\n",sym->s_class);
}


/* Generate code to push the necessary info to call RTS entry "sr_make_resops".
   This is
   	a) for procs, the flag PROC_OP and the address of the proc.
	b) for input ops, the flag INPUT_OP and the address that the class-id.
*/
static void
gen_make_op(sym,op_cnt)
Symptr sym;
int op_cnt;
{
    if (op_cnt == 0)
	cprintf("sr_make_resops(");
    if (sym->s_impl == IM_INPUT) {
	cprintf("%d,A(%C),",(int)INPUT_OP,sym->s_class);
	gen_ne_sym(sym);
	cprintf(",");
    } else {
	truncname(sym->s_name, NAMESIZE-2);
	cprintf("%hstatic P%s();\n",sym->s_name);
	cprintf("%d,P%s,", (int) (sym->s_reply ? PROC_REP_OP : PROC_OP),
	    sym->s_name);
    }
}


void
gen_block_prequel(sym)
Symptr sym;
{
    assert(sym->s_kind == K_BLOCK);
    /* keep track of current block */
	if (++ bl_sp == MAX_NEST)
	    boom("nesting too deep");
	cur_bl[bl_sp] = sym;
}


void
gen_block_postquel()
{
    Symptr sym, s;
    sym = cur_bl[bl_sp];
    assert(sym->s_kind == K_BLOCK);
    for (s=sym->s_next; s; s=s->s_next) {
	if (s->s_kind == K_OP && s->s_impl == IM_INPUT) {
	    cprintf("sr_kill_liop(%A,",s);
	    gen_ne_sym(s);
	    cprintf(");\n");
	}
    }
    -- bl_sp;
}



static void
gen_ne_sym(s)
Symptr s;
{
    Nodeptr r;

    if (!s->s_ranges)
	cprintf("1");
    else {
	r = s->s_ranges->r_dim1;
	cprintf("((%e-%e+1",r->e_r,r->e_l);
	if (r = s->s_ranges->r_dim2)  {
	    cprintf(")*(%e-%e+1",r->e_r,r->e_l);
	}
	cprintf("))");
    }
}
