/*
 *  SR Run-Time Support.  Virtual Machine Management.
 */

#include "rts.h"



/*
 *  Specify location of physical machine.
 */
void
sr_locate (n, phost, lhost, pexe, lexe)		/* RTS Primitive */
int n, lhost, lexe;
char *phost, *pexe;
{
    struct locn_st lr;
    pach ph;
    int size;

    sr_check_stk();

    sr_init_net ((daddr) NULL);		/* start up the network, if not up */
    size = PACH_SZ + sizeof(int) + ((lhost + 1 + lexe + 1 + 3) & ~3);
    if (size > sizeof(lr))
	sr_abort ("strings too long in locate call");
    lr.num = n;
    memcpy (lr.text, phost, lhost);
    lr.text [lhost] = '\0';
    memcpy (lr.text + lhost + 1, pexe, lexe);
    lr.text [lhost + 1 + lexe] = '\0';
    ph = sr_remote (SRX_VM, REQ_LOCVM, (pach) &lr, size);
    sr_free ((daddr) ph);		/* free reply packet */
}



/*
 *  Create new virtual machine.
 */
void
sr_crevm (vmp, physm)				/* RTS Primitive */
int *vmp;
int physm;
{
    struct num_st vr;
    pach ph;

    sr_check_stk();

    sr_init_net ((daddr) NULL);		/* start up the network, if not up */
    vr.num = physm;			/* set physical machine */
    ph = sr_remote (SRX_VM, REQ_CREVM, (pach) &vr, sizeof (vr));
					/* call srx to create the vm */
    *vmp = ((struct num_st *)ph)->num;	/* save virtual machine no. */
    sr_free ((daddr) ph);			/* free reply packet */
}



/*
 *  Destroy virtual machine.
 */
void
sr_destvm (vm)					/* RTS Primitive */
int vm;
{
    struct num_st vr;
    pach ph;

    sr_check_stk();
    if (vm == NOOP_VM)
	return;
    if (vm == NULL_VM)
	sr_abort ("attempting to destroy null vm");

    sr_init_net ((daddr) NULL);		/* start network if not up */
    vr.num = vm;			/* set virtual machine number */
    ph = sr_remote (SRX_VM, REQ_DESTVM, (pach) &vr, sizeof(vr));
					/* ask srx to destroy the vm */
    sr_free ((daddr) ph);			/* free reply packet */
}
