/* spectrum.s  --  HP 9000/840 assembly language code
 *
 * a HP 9000/840 SR context array is laid out like this:
 *
 *      arguments ( at least 16 bytes )                 (low addresses)
 *      procedure mark ( 32 bytes )
 *      sequence of stack frames
 *	unused stack space   <--  saved sp points to loweest unused address
 *	magic word for checking integrity
 *	saved registers                                 (high addresses)
 *
 * The following registers are saved: 
 * r2-r18, r27, r30, all fr0-fr3, fr12-fr15, sr0-sr4.
 * Temporary hack:  For now we save all registers.
 * Future work:  Make sr_chg_context so that if the (SR) stack is corrupted,
 * the debugger can trace back from sr_stack_corrupted and find what was
 * going on.
 *
 */
	.GLOBAL
	.LIT
MAGIC	.EQU	618033989		/* any unlikely long integer
					used to detect stack overflow */
SAVE_AREA_SIZE	.EQU	272		/* size of register save area */
FRAME_MARKER_SIZE	.EQU	32

	.DATA
	.EXPORT curr_stack
curr_stack 	  
	.WORD	0


	.CODE
	.EXPORT	sr_build_context, CODE
	.EXPORT sr_chg_context, CODE
	.EXPORT sr_check_stk, CODE
	.EXPORT sr_stack_underflow, CODE
	.IMPORT sr_stk_overflow, CODE	/* main.c */
	.IMPORT sr_stk_underflow, CODE	/* main.c */
	.IMPORT sr_stk_corrupted, CODE	/* main.c */



/*  sr_build_context(code,stack,stacksize,arg3,arg4,arg5,arg6)
 *      -- create a new context.
 *
 *  code is the entry point of the code to be executed in the context.
 *  stack is a buffer for holding the stack.
 *  stacksize is the size of this buffer.
 *  arg[3-6] are extra arguments, not all of them always used.
 */
	.CODE
sr_build_context
	.PROC
	.CALLINFO
	.ENTRY	
        STW	%r2, -20(%sp)	/* store return address in caller's frame */

	/* Check and adjust alignment. */
	BB,<	%arg1,29,aligned	/* if 29th bit of context stack is 1 */
	LDO	4(%arg1),%r22		/* %r22 = pointer to stack buffer */
	LDO	4(%r22),%r22		/* align to double word */
	LDO	-4(%arg2),%arg2		/* subtract 4 from stacksize */
aligned
	STW	%arg2,0(%arg1)		/* store stacksize in base of stack */
	ADD	%arg1,%arg2,%r21	/* %r21 = end of context stack */

	/* save args */
	LDW	-60(%sp),%r20		/* load arg4 in temporary register */
	STW	%r20,0(%r22)		/* store in context stack */
	LDO	4(%r22),%r22		/* bump context stack */
	LDW	-56(%sp),%r20		/* and so on for 5 and 6 */
	STW	%r20,0(%r22)
	LDO	4(%r22),%r22
	LDW	-52(%sp),%r20
	STW	%r20,0(%r22)
	LDO	4(%r22),%r22
	STW	%arg3,0(%r22)		/* arg3 is in a register already */
	LDO	4(%r22),%r22		/* bump context stack */

	/* load args in the dedicated registers */
	LDW	-4(%r22), %r20		/* we'll move r20 to arg0 later */
	LDW	-8(%r22), %arg1		
	LDW	-12(%r22), %arg2
	LDW	-16(%r22), %arg3
	LDO	FRAME_MARKER_SIZE(%r22), %r22	
				/* reserve space for procedure mark */
	STW	%r0,-4(%r22)	/* zero -> previous sp to stop stack trace */
	STW	%arg0, 4(%r22)	/* store address for starting execution */
	LDO	8(%r22), %r22
	COPY	%r20, %arg0
	ADDIL	L%under, %r0		/* result in %r1 */
	LDO	R%under(%r1), %r2  	/* store error address in %r2 */
	COPY	%sp, %r19
	COPY	%r22, %sp
	
	STW	%r1, -4(%r21)		/* general registers */
	STW	%r2, -8(%r21)
	STW	%r3, -12(%r21)
	STW	%r4, -16(%r21)
	STW	%r5, -20(%r21)
	STW	%r6, -24(%r21)
	STW	%r7, -28(%r21)
	STW	%r8, -32(%r21)
	STW	%r9, -36(%r21)
	STW	%r10, -40(%r21)
	STW	%r11, -44(%r21)
	STW	%r12, -48(%r21)
	STW	%r13, -52(%r21)
	STW	%r14, -56(%r21)
	STW	%r15, -60(%r21)
	STW	%r16, -64(%r21)
	STW	%r17, -68(%r21)
	STW	%r18, -72(%r21)
	STW	%r19, -76(%r21)
	STW	%r20, -80(%r21)
	STW	%r21, -84(%r21)
	STW	%r22, -88(%r21)
	STW	%r23, -92(%r21)
	STW	%r24, -96(%r21)
	STW	%r25, -100(%r21)
	STW	%r26, -104(%r21)
	STW	%r27, -108(%r21)
	STW	%r28, -112(%r21)
	STW	%r29, -116(%r21)
	STW	%r30, -120(%r21)
	STW	%r31, -124(%r21)
	LDO	-132(%r21), %r22	/* %r22 must be 8 bytes aligned */
	FSTDS, MA	%fr0, -8(%r22)	/* floating point registers */
	FSTDS, MA	%fr1, -8(%r22)
	FSTDS, MA	%fr2, -8(%r22)
	FSTDS, MA	%fr3, -8(%r22)
	FSTDS, MA	%fr4, -8(%r22)
	FSTDS, MA	%fr5, -8(%r22)
	FSTDS, MA	%fr6, -8(%r22)
	FSTDS, MA	%fr7, -8(%r22)
	FSTDS, MA	%fr8, -8(%r22)
	FSTDS, MA	%fr9, -8(%r22)
	FSTDS, MA	%fr10, -8(%r22)
	FSTDS, MA	%fr11, -8(%r22)
	FSTDS, MA	%fr12, -8(%r22)
	FSTDS, MA	%fr13, -8(%r22)
	FSTDS, MA	%fr14, -8(%r22)
	FSTDS, MA	%fr15, -8(%r22)
	MFSP	%sr0, %r22		/* space registers */
	STW	%r22, -256(%r21)
	MFSP	%sr1, %r22
	STW	%r22, -260(%r21)
	MFSP	%sr2, %r22
	STW	%r22, -264(%r21)
	MFSP	%sr3, %r22
	STW	%r22, -268(%r21)
	MFSP	%sr4, %r22
	STW	%r22, -272(%r21)
	LDO 	-SAVE_AREA_SIZE(%r21), %r21
	LDIL	L%MAGIC, %r31	/* store magic word for integrity checking */
	LDO	R%MAGIC(%r31), %r31
	STW	%r31, -4(%r21)

	COPY	%r19, %sp		/* restore our stack pointer */
	LDW	-20(%sp), %r2		/* restore our return address */
	BV, N	0(2)			/* return */
	.PROCEND

/* sr_chg_context(newstack) -- switch to the specified stack */
sr_chg_context
	.PROC
	.CALLINFO 
	.ENTRY
	LDIL	L%MAGIC, %r20		/* %r20 = magic word for integrity check*/
	LDO	R%MAGIC(%r20), %r20

	ADDIL	L%curr_stack-$global$, %dp	/* load address of current stack */
	LDW	R%curr_stack-$global$(%r1), %r21	
	COMIBT,=	0, %r21, first_time
	NOP
	LDW	0(%r21), %r19		/* load stacksize */
	ADD	%r21, %r19, %r19	/* %r19 = end of stack */	

 	/* store return address at %sp */
 	LDO	8(%sp), %sp		/* must increment sp first, 
						keep 8-byte aligned */
 	STW	%r2, -4(%sp)
 
        /* copy the registers of current context*/
	STW	%r1, -4(%r19)		/* general registers */
	STW	%r2, -8(%r19)
	STW	%r3, -12(%r19)
	STW	%r4, -16(%r19)
	STW	%r5, -20(%r19)
	STW	%r6, -24(%r19)
	STW	%r7, -28(%r19)
	STW	%r8, -32(%r19)
	STW	%r9, -36(%r19)
	STW	%r10, -40(%r19)
	STW	%r11, -44(%r19)
	STW	%r12, -48(%r19)
	STW	%r13, -52(%r19)
	STW	%r14, -56(%r19)
	STW	%r15, -60(%r19)
	STW	%r16, -64(%r19)
	STW	%r17, -68(%r19)
	STW	%r18, -72(%r19)
	STW	%r19, -76(%r19)
	STW	%r20, -80(%r19)
	STW	%r21, -84(%r19)
	STW	%r22, -88(%r19)
	STW	%r23, -92(%r19)
	STW	%r24, -96(%r19)
       	STW    	%r25, -100(%r19)
	STW	%r26, -104(%r19)
	STW	%r27, -108(%r19)
	STW	%r28, -112(%r19)
	STW	%r29, -116(%r19)
	STW	%r30, -120(%r19)
	STW	%r31, -124(%r19)
	LDO	-132(%r19), %r22	/* %r22 must be 8 bytes aligned */
	FSTDS, MA	%fr0, -8(%r22)	/* floating point registers */
	FSTDS, MA	%fr1, -8(%r22)
	FSTDS, MA	%fr2, -8(%r22)
	FSTDS, MA	%fr3, -8(%r22)
	FSTDS, MA	%fr4, -8(%r22)
	FSTDS, MA	%fr5, -8(%r22)
	FSTDS, MA	%fr6, -8(%r22)
	FSTDS, MA	%fr7, -8(%r22)
	FSTDS, MA	%fr8, -8(%r22)
	FSTDS, MA	%fr9, -8(%r22)
	FSTDS, MA	%fr10, -8(%r22)
	FSTDS, MA	%fr11, -8(%r22)
	FSTDS, MA	%fr12, -8(%r22)
	FSTDS, MA	%fr13, -8(%r22)
	FSTDS, MA	%fr14, -8(%r22)
	FSTDS, MA	%fr15, -8(%r22)
	MFSP	%sr0, %r22		/* space registers */
	STW	%r22, -256(%r19)
	MFSP	%sr1, %r22	
	STW	%r22, -260(%r19)
	MFSP	%sr2, %r22	
	STW	%r22, -264(%r19)
	MFSP	%sr3, %r22	
	STW	%r22, -268(%r19)
	MFSP	%sr4, %r22	
	STW	%r22, -272(%r19)

	/* test the state of the old stack */
	LDO	-SAVE_AREA_SIZE(%r19), %r19
	COMB,<=	%r19, %sp, over		/* check the stack isn't overflowing */
	NOP
	LDW	-4(%r19), %r21
	COMB,<>	%r20, %r21, over 	/* check earlier overflow (maybe)*/
	NOP

first_time
	COPY	%arg0, %r21		/* load address of new context */
	LDW	0(%r21), %r19		/* load stacksize */
	ADD	%r21, %r19, %r19	/* %r19 = end of stack */	
	LDW	-SAVE_AREA_SIZE-4(%r19), %r21
	COMB,<>	%r20, %r21, bad 	/* make sure new stack is okay */
	NOP
	
	ADDIL	L%curr_stack-$global$, %dp /* result in %r1 */
	STW	%arg0, R%curr_stack-$global$(%r1)
	
	/* load all the registers from the new context stack */
	/* again I'll cut a lot of this out when I get around to it. */
	LDW	-4(%r19), %r1		/* general registers */
	LDW	-8(%r19), %r2
	LDW	-12(%r19), %r3
	LDW	-16(%r19), %r4
	LDW	-20(%r19), %r5
	LDW	-24(%r19), %r6
	LDW	-28(%r19), %r7
	LDW	-32(%r19), %r8
	LDW	-36(%r19), %r9
	LDW	-40(%r19), %r10
	LDW	-44(%r19), %r11
	LDW	-48(%r19), %r12
	LDW	-52(%r19), %r13
	LDW	-56(%r19), %r14
	LDW	-60(%r19), %r15
	LDW	-64(%r19), %r16
	LDW	-68(%r19), %r17
	LDW	-72(%r19), %r18
	/* do not store over %r19 */
	LDW	-80(%r19), %r20
	LDW	-84(%r19), %r21
	LDW	-88(%r19), %r22
	LDW	-92(%r19), %r23
	LDW	-96(%r19), %r24
	LDW	-100(%r19), %r25
	LDW	-104(%r19), %r26
	LDW	-108(%r19), %r27
	LDW	-112(%r19), %r28
	LDW	-116(%r19), %r29
	LDW	-120(%r19), %r30
	LDW	-124(%r19), %r31
	LDO	-252(%r19), %r22
	FLDDS		0(%r22), %fr15	/* floating point registers */
	FLDDS, MB	8(%r22), %fr14
	FLDDS, MB	8(%r22), %fr13
	FLDDS, MB	8(%r22), %fr12
	FLDDS, MB	8(%r22), %fr11
	FLDDS, MB	8(%r22), %fr10
	FLDDS, MB	8(%r22), %fr9
	FLDDS, MB	8(%r22), %fr8
	FLDDS, MB	8(%r22), %fr7
	FLDDS, MB	8(%r22), %fr6
	FLDDS, MB	8(%r22), %fr5
	FLDDS, MB	8(%r22), %fr4
	FLDDS, MB	8(%r22), %fr3
	FLDDS, MB	8(%r22), %fr2
	FLDDS, MB	8(%r22), %fr1
	FLDDS, MB	8(%r22), %fr0	/* %fr0 must be loaded last */
	LDW	-256(%r19), %r22	/* space registers */
	MTSP	%r22, %sr0
	LDW	-260(%r19), %r22
	MTSP	%r22, %sr1
	LDW	-264(%r19), %r22
	MTSP	%r22, %sr2
	LDW	-268(%r19), %r22
	MTSP	%r22, %sr3
	LDW	-272(%r19), %r22
	MTSP	%r22, %sr4
	/* jump into new context */
 	LDW	-4(%sp), %r20		/* restore code entry address */
 	LDO 	-8(%sp), %sp		/* must decrement sp *after* retreiving */
	BV	0(%r20)				
	NOP
	.EXIT
	.PROCEND

	
sr_check_stk
	.PROC
	.CALLINFO
	.ENTRY
        STW	%r2, -20(%sp)		/* store return address in caller's fr*/
	ADDIL	L%curr_stack-$global$, %dp	/* result in %r1 */
	LDW	R%curr_stack-$global$(%r1), %r21
	LDW	0(%r21), %r19			/* load stacksize */
	ADD	%r21, %r19, %r19
	LDO	-SAVE_AREA_SIZE(%r19), %r19
	COMB,<=	%r19, %sp, over			/* check stack overflow */
	NOP
	LDW	-20(%sp), %r2		/* restore our return address */
	BV	0(2)			/* return */
	NOP
	.EXIT
	.PROCEND

over	LDIL	L%sr_stk_overflow, %r1
	BLE, N	R%sr_stk_overflow(%sr4, %r1)

sr_stack_underflow
	.PROC
	.CALLINFO
	.ENTRY
	/* We make a horrible jump to 'under'.  This procedure is
	never really called.  It is here to make stack traces in
	the debugger look nicer.  */	
under	LDIL	L%sr_stk_underflow, %r1
	BLE, N	R%sr_stk_underflow(%sr4, %r1)
	.EXIT
	.PROCEND


bad	LDIL	L%sr_stk_corrupted, %r1
	BLE, N	R%sr_stk_corrupted(%sr4, %r1)
	.END
