/*
 *	SR Run-Time Support.  Collected General Definitions.
 */

#define INIT_SEQ_CO  (short) 0x6A6A	/* co initial sequence number */
#define INIT_SEQ_OP  (short) 0x27C3	/* op initial sequence number */
#define INIT_SEQ_RES (short) 0x34F5	/* resource initial sequence number */

#define Bool int /* Pseudo-type to make C more like Pascal !!*/
#define TRUE  1  /* Boolean */
#define FALSE 0  /* Boolean */

#define MEMH_SZ (sizeof (struct memh_st))  /* size of memblk hdr */

#define rts_error(s) (sr_message ("error", s))
#define rts_warn(s)  (sr_message ("warning", s))

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

#include "../libc.h"
#include "../config.h"
#include "../srsys.h"
#include "types.h"

#include "procsem.h"
#include "netw.h"
#include "oper.h"
#include "res.h"

#include "funcs.h"
#include "macros.h"

#include "globals.h"



/*  select() stuff -- 
 *  would be cleaner if the various systems had consistent include files */

#include <sys/file.h>

#ifndef FD_SETSIZE	/* 4.3BSD defines these */
#define FD_SETSIZE 32
#define FD_SET(n,p)	((p)->fds_bits[0] |= (1<<(n)))
#define FD_CLR(n,p)	((p)->fds_bits[0] &= ~(1<<(n)))
#define FD_ISSET(n,p)	((p)->fds_bits[0] & (1<<(n)))
#endif /* FD_SETSIZE */
