/*
 *  SR Run-Time Support.  Data Structures and Macros for the Network.
 */


/*  Version number for the protocol used between srx and the runtime system.
 *  Increment this whenever the interface changes; then srx can detect
 *  connection attempts from mismatched executables, instead of simply
 *  malfunctioning.  */

#define PROTO_VER "v003"



/*  other general definitions */

#define PACH_SZ (sizeof (struct pach_st))
#define PBUF_SZ 1024	/* size of buffer for incoming packets */

#define VM_MAGIC "[SR]"	/* magic word for argv[1] on exec calls */

#define SRX_VM 0	/* virtual machine number for srx */
#define MAIN_VM	1	/* virtual machine number for main machine */
#define MAX_VM 253	/* maximum VM number (limited by tindex size) */
#define NOOP_VM 254	/* special code for NOOP vmcap */
#define NULL_VM 255	/* special code for NULL vmcap */

#define SOCK_ADDR_SIZE	24	/* size of socket address as a string */



/*  remote request message descriptor */

struct remd_st {
    pach ph;		/* outgoing request packet */
    sem wait;		/* semaphore to wait for reply on */
    pach reply;		/* incoming reply message */
    remd next;		/* free list link */
};



/*  number message -- MSG_EXIT, REQ_CALLME, REQ_CREVM, REQ_DESTVM,
			ACK_CREVM, REQ_FINDVM  */

struct num_st {
    struct pach_st ph;	/* packet header */
    int num;		/* exit code or phys or virt machine num */
};



/*  socket address message -- MSG_HELLO, ACK_FINDVM, REQ_LOCVM  */

struct saddr_st {
    struct pach_st ph;		/* packet header */
    char addr[SOCK_ADDR_SIZE];	/* socket address */
};



/*  location message -- REQ_LOCVM  */

struct locn_st {
    struct pach_st ph;	/* packet header */
    int num;		/* physical machine number */
    char text[1000];	/* hostname, then path  (may be shorter) */
};
