/*  machine.c - include correct assembly language file for host architecture.
 *
 *  This file is run through cc -E, postprocessed, then fed to as(1).
 *  See the Makefile for details.
 */

#ifndef lint

#ifdef vax
#define ARCH vax
#include "vax.s"
#endif

#ifdef mips
#define ARCH mips
#include "mips.s"
#endif

#ifdef sparc
#define ARCH sparc
#include "sparc.s"
#endif

#ifdef mc68000
#define ARCH m68k
#include "m68k.s"
#endif

#ifdef ns32000
#define ARCH ns32
#include "encore.s"
#endif

#ifdef hp9000s800
#define ARCH spectrum
#include "spectrum.s"
#endif

#ifdef hp9000s300
#define ARCH bobcat
#include "bobcat.s"
#endif

#ifndef ARCH
    ERROR -- no architecture selected
#endif

#endif /* lint */
