/*
 *  SR Run-Time Support -- Nugget.  Routines for Input Operation Processing.
 */

#include "rts.h"

/*
 *  Append an invocation block to the
 *  end of the specified invocation list.
 */
#define append(ibp,ilist)	{ \
    \
    if (( (ilist).head) == NULL) { \
	(ilist).head = (ibp); \
	(ilist).tail = (ibp); \
	(ibp)->last = NULL; \
    } \
    else { \
	(ilist).tail->next = (ibp); \
	(ibp)->last = (ilist).tail; \
	(ilist).tail = (ibp); \
    } \
}


 
/*
 *  Append an invocation list to the
 *  end of the specified invocation list.
 */
#define appendlist(ibl,ilist)	{ \
    \
    if (( (ilist).head) == NULL) { \
	(ilist)= (ibl); \
    } \
    else { \
	(ilist).tail->next = (ibl).head; \
	(ibl).head->last = (ilist).tail; \
	(ilist).tail = (ibl).tail; \
    } \
}



/*  Remove a node from a single-headed doubly-linked list.  */

#define delete_inv(node,queue,next,last) { \
    if (node->last == NULL) { \
        if (((queue).head = node->next) != NULL) { \
            (queue).head->last = NULL; } \
	else { (queue).tail = NULL; } \
    } else if ((node->last->next = node->next) != NULL) \
        node->next->last = node->last; \
    else { \
	(queue).tail = node->last;} \
}




/*
 *  Invoke an input operation.  Place the invocation block on the appropriate
 *  list.  Wake up process if new invocation could possibly satisfy guard in
 *  its input statement.
 */
void
sr_invk_iop (ibp, clap)
invb ibp;
class clap;
{
    oper op;
    
    op = sr_optab + ibp->opc.oper_index;
    op->pending++;

    ibp->next = NULL;
    clap->pending++;
    
    if (clap->inuse)
	append (ibp, clap->new_in)
    else {
	append (ibp, clap->old_in)
	if (clap->new_pr.head == NULL) { 
	    clap->new_pr.head = clap->old_pr.head;
	}
	else 
	    clap->new_pr.tail->next = clap->old_pr.head;
	clap->new_pr.tail = clap->old_pr.tail;
	clap->old_pr.head = NULL;
	clap->old_pr.tail = NULL;
	
	if (clap->new_pr.head != NULL) {
	    clap->inuse = TRUE;
	    clap->new_pr.head->next_inv = clap->old_in.head;
            if (clap->new_pr.head->else_leg) {
                clap->else_pr = clap->else_pr->next_else;
                if (clap->else_pr == NULL)
                    clap->else_tailpr = NULL;
	    }
	    awaken (clap->new_pr);
	}
    }
}



/*
 *  Gain initial access to an input operation class.
 *  Allows GC to start searching for a valid invocation.
 */
void
sr_iaccess (clap,else_present)				/* RTS Primitive */
class clap;
Bool else_present;
{

    sr_check_stk();
    
    sr_cur_proc->clap = clap;
    sr_cur_proc->else_leg = else_present;
    if (clap->inuse) {
	block (&clap->new_pr);
	if (sr_cur_proc->else_leg) {
	    if (clap->else_pr == NULL) {
                clap->else_pr = sr_cur_proc;
                clap->else_tailpr = sr_cur_proc;
	    }
	    else {
	    	clap->else_tailpr->next_else = sr_cur_proc;
	    	clap->else_tailpr= sr_cur_proc;
	    }
	    clap->else_tailpr->next_else = NULL;
	}
	sr_cswitch();
    }
    else {
	clap->inuse = TRUE;
	sr_cur_proc->next_inv = clap->old_in.head;
    }
}



/*
 *  Regain subsequent access to an input operation class.
 */
void
sr_reaccess ()
{
    class clap;

    clap = sr_cur_proc->clap;
    if (clap->new_in.head == NULL) {
	/*
	 *	No new invocations for me, so block.  Give access
	 *	to class if any other process wants to see it.
	 */
	block (&clap->old_pr);
	if (clap->new_pr.head == NULL)
	    clap->inuse = FALSE;
	else {
	    clap->new_pr.head->next_inv = clap->old_in.head;
	    if (clap->new_pr.head->else_leg) {
		clap->else_pr = clap->else_pr->next_else;
		if (clap->else_pr == NULL)
		    clap->else_tailpr = NULL;
	    }
	    awaken (clap->new_pr);
	}

	sr_cswitch();
    }

    else {
	/*
	 *	New invocations have arrived since the last time
	 *	this process searched the invocation queue.
	 *	Oldest process doing a reaccess() gets to look at
	 *	next invocation, proceeding in FCFS order until it's
	 *	my turn again.  If no older processes, just go around.
	 */
	appendlist (clap->new_in, clap->old_in);
	clap->new_in.tail = NULL;
	clap->new_in.head = NULL;

	if ((clap->old_pr.head) != NULL) {
            block (&clap->old_pr);
	    clap->old_pr.tail->next = clap->new_pr.head;
	    clap->new_pr.head = clap->old_pr.head;
	    if (clap->new_pr.tail == NULL) 
		clap->new_pr.tail = clap->old_pr.tail;
	    clap->old_pr.head = NULL;
	    clap->old_pr.tail = NULL;
	    clap->new_pr.head->next_inv = clap->old_in.head;

	    if (clap->new_pr.head->else_leg) {
		clap->else_pr = clap->else_pr->next_else;
		if (clap->else_pr == NULL)
		    clap->else_tailpr = NULL;
	    }
	    awaken (clap->new_pr);
	    sr_cswitch();
	}
	else
	    sr_cur_proc->next_inv = clap->old_in.head;
    }
}



/*
 *  Remove an invocation block from the specified input
 *  operation queue.  The GC can service the invocation now.
 */
void
sr_rm_iop (ibp)					/* RTS Primitive */
invb ibp;
{
    class clap;
    oper op;
    proc pr;

    sr_check_stk();
    
    clap = sr_cur_proc->clap;
    /*
     *  if processing an else leg don't actually remove an
     *  invocation.
     */
    if (ibp != NULL) {
    	op = sr_optab + ibp->opc.oper_index;
    	op->pending--;
    
    	clap->pending--;
    	delete_inv (ibp, clap->old_in, next, last);
    }

/*
 *  Handle any other processes waiting for this class.
 */
    if (clap->new_in.head == NULL) {
	/*
	 * No new invocations.  Give access to class if any other process
	 * wants to see it.
	 */
	if (clap->old_in.head == NULL) {
	    if (clap->else_pr == NULL) {
	    	if (clap->new_pr.head) {
		    if (clap->old_pr.head) {
		    	clap->old_pr.tail->next = clap->new_pr.head;
		    }
		    else
			clap->old_pr.head = clap->new_pr.head;
		    clap->old_pr.tail = clap->new_pr.tail;
		    clap->new_pr.head = NULL;
		    clap->new_pr.tail = NULL;
		}
	        clap->inuse = FALSE;
	    }
	    else {
		/*
		 * NEVER AN ELSE ON THE OLD_PR
		 * 	move processes from new process list to old process
		 *	list until reach a blocked process with an else
		 */
		pr = clap->new_pr.head;
		if (!pr->else_leg) {
		    
		    while ((pr->next ) &&  pr->next->else_leg == FALSE ) {
		    	pr = pr->next;		
		    }
		    if (clap->old_pr.head) {
		    	clap->old_pr.tail->next = clap->new_pr.head;
		    	clap->old_pr.tail = pr;
		    }
		    else {
		    	clap->old_pr.head = clap->new_pr.head;
		    	clap->old_pr.tail = pr;
		    }
		    clap->new_pr.head = pr->next;
		}
		clap->else_pr = clap->else_pr->next_else;
		if (clap->else_pr == NULL) {
		    	clap->else_tailpr = NULL;
		}
		clap->new_pr.head->next_inv = NULL;
		awaken (clap->new_pr);
	    }
	}
	else {
	    if (clap->new_pr.head == NULL)
		clap->inuse = FALSE;
	    else {
		clap->new_pr.head->next_inv = clap->old_in.head;
		if (clap->new_pr.head->else_leg) {
		    clap->else_pr = clap->else_pr->next_else;
		    if (clap->else_pr == NULL) {
		    	clap->else_tailpr = NULL;
		    }
		}
		awaken (clap->new_pr);
	    }
	}
    }
    else {
	/*
	 *  New invocations have arrived. Does any process need to look at them?
	 */
	appendlist (clap->new_in, clap->old_in);
	clap->new_in.head = NULL;
	clap->new_in.tail = NULL;

	if (clap->old_pr.head) {
	    if (clap->new_pr.head) 
	        clap->old_pr.tail->next = clap->new_pr.head;
	    else
	    	clap->new_pr.tail = clap->old_pr.tail;

	    clap->new_pr.head = clap->old_pr.head;
	    clap->old_pr.head = NULL;
	    clap->old_pr.tail = NULL;
	}

	if (clap->new_pr.head) {
	    clap->new_pr.head->next_inv = clap->old_in.head;
	    if (clap->new_pr.head->else_leg) {
		    clap->else_pr = clap->else_pr->next_else;
		    if (clap->else_pr == NULL) {
		    	clap->else_tailpr = NULL;
		    }
	    }
	    awaken (clap->new_pr);
	}
	else
	    clap->inuse = FALSE;
    }
} 
