/*
 *  SR Run-Time Support. Global Definitions.
 *
 *  Globals are declared here for all to use and actually defined in main.c.
 */

#ifndef global
#define global extern
#define initval(v)
#endif



global int sr_argc;		/* program argument count */
global char **sr_argv;		/* program argument vector */

global int sr_my_machine;	/* current machine number */
global int sr_my_vm;		/* current virtual machine number */
global char sr_my_label[100];	/* diagnostic label for this vm */

global rescap sr_nu_rcap;	/* null resource capability */
global rescap sr_no_rcap;	/* noop resource capability */
global rescap sr_main_res;	/* main resource capability */
global rint sr_cur_res;		/* current resource */

global oper sr_optab;		/* operation table */
global opcap sr_nu_ocap;	/* null operation capability */
global opcap sr_no_ocap;	/* noop operation capability */

global int sr_nu_vmcap initval(NULL_VM);	/* null vm capability */
global int sr_no_vmcap initval(NOOP_VM);	/* noop vm capability */

global FILE *sr_stdin, *sr_stdout, *sr_stderr; /* pointers to standard files */

global bool sr_exec_up;		/* is srx up yet? */

global sem sr_rid_count;
global sem sr_class_count;	/* available class table entries */
global sem sr_cob_avail;	/* available coblocks */
global sem sr_rem_count;
global oper sr_oper_free;	/* operation free list */



/*  Process control variables.  */

global proc sr_cur_proc;	/* current process */
global proc_queue sr_ready_list;/* list of process ready to run */

global int sr_num_blocked;	/* number of blocked processes */

global int sr_rem_loops;	/* remaining loop traversals before
				   context switch time */


/*  These variables are defined and initialized by the linker.  */

extern struct rpat_st sr_rpat[];/* resource pattern table */

extern int sr_max_co_stmts;	/* limit on active "co" statements */
extern int sr_max_classes;	/* limit on "in" operation classes */
extern int sr_max_loops;	/* max loop traversals before context switch */
extern int sr_max_operations;	/* limit on active operations */
extern int sr_max_processes;	/* limit on number of processes */
extern int sr_max_rmt_reqs;	/* limit on pending remote requests */
extern int sr_max_resources;	/* limit on active resources */
extern int sr_max_semaphores;	/* limit on number of semaphores */

extern int sr_stack_size;	/* size of a process stack */

extern int sr_trace_flag;	/* trace runtime startups? */

extern char sr_exec_path[];	/* path to find srx executable */
