/*  csw.c -- context switch test
 *
 *  This program is not part of SR but is used to test new xxxx.s files
 *  when porting SR to new architectures.
 *
 *  Type "make csw" to build, then "csw" to run;  correct output is
 *  in csw.stdout.  A "stack underflow" error IS EXPECTED at the end.
 */


#include <stdio.h>

#define STACK_SIZE 2000
#define CK_BEFORE 0xB4B4B4B4
#define CK_AFTER  0xAFAFAFAF
#define MAX_RECURSE 20

extern void sr_build_context();
extern void sr_chg_context();

/* enclose the stacks in a larger structure, to check for errors */

struct envelope {
    int before;
    char stack[STACK_SIZE];
    int after;
} r0, r1, r2, r3, r4, r9;	/* r0, r9 are extra padding for safety */


/* four stacks for testing */

char *s1 = r1.stack;
char *s2 = r2.stack;
char *s3 = r3.stack;
char *s4 = r4.stack;



/*  main program.
 *
 *  create four contexts, then jump to one of them.
 */

main()
{
    int foo(), bar(), baz(), boo();
    static char *p[] = {"one", "two", "three"};

    r1.before = r2.before = r3.before = r4.before = CK_BEFORE;
    r1.after = r2.after = r3.after = r4.after = CK_AFTER;
    spawn(foo,s1,p[0],0,0,0);       check_context(&r1,"s1");
    spawn(bar,s2,p[1],p[2],0,0);    check_context(&r2,"s2");
    spawn(baz,s3,p[0],p[1],p[2],0); check_context(&r3,"s3");
    spawn(boo,s4,p[0],p[1],p[2],0); check_context(&r4,"s4");
    sr_chg_context(s4);		/* should not return */
    write(1,"Z\n",2);		/* ERROR */
    err("returned to main program after chg_context");
}



/*  spawn a process.  */

spawn(pc,stack,arg1,arg2,arg3,arg4) 
void (*pc)();
char *stack;
int arg1, arg2, arg3, arg4;
{
    sr_build_context(pc,stack,STACK_SIZE,arg1,arg2,arg3,arg4);
}



/*  check that context creation didn't step out of bounds on either end.  */

check_context(r,s)
struct envelope *r;
char *s;
{
    if (r->before == CK_BEFORE && r->after == CK_AFTER)  {
	printf("stack %s created\n",s);
	return;
    }
    if (r->before != CK_BEFORE)
	printf("stack %s creation destroyed data before beginning\n",s);
    if (r->after != CK_AFTER)
	printf("stack %s creation destroyed data beyond end\n",s);
    exit(1);
}



/*  four coroutines for checking context switching.  */

foo(a)
char *a;
{
    printf(" 5. foo1(%s)\n",a);
    sr_check_stk();
    sr_chg_context(s2);
    printf(" 8. foo2(%s)\n",a);
    sr_check_stk();
    sr_chg_context(s3);
    printf("XX. foom!!!!!!!\n");
    exit(1);
}

bar(a,b)
char *a, *b;
{
    printf(" 6. bar1(%s,%s)\n",a,b);
    sr_check_stk();
    sr_chg_context(s3);
    printf("10. bar2(%s,%s)\n",a,b);
    sr_check_stk();
    printf("now expect underflow error:\n");
    return;	/* should underflow and be caught */ 
}

baz(a,b,c)
char *a, *b, *c;
{
    printf(" 7. baz1(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s1);
    printf(" 9. baz2(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s2);
    printf("XX. bazzzzzzzt!!!!!\n");
    exit(1);
}

boo(a,b,c)
char *a, *b, *c;
{
    printf(" 1. boo1(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s4);
    printf(" 2. boo2(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s4);
    printf(" 3. boo3(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s4);
    printf(" 4. boo4(%s,%s,%s)\n",a,b,c);
    sr_check_stk();
    sr_chg_context(s1);
    printf("XX. boom!!!!!!!\n");
    exit(1);
}



/*  error handling  */

sr_stk_overflow()  {err("stack overflow");}
sr_stk_underflow() {err("stack underflow");}
sr_stk_corrupted() {err("stack corrupted");}

err(s)
char *s;
{
    puts(s);
    exit(1);
}




/*  dump stack s; use this to help with debugging if you want  */

dstack(s,label)
char *s, *label;
{
    dump(s,0,52,label);
    dump(s,STACK_SIZE-100,STACK_SIZE-1,"");
}




/* dump(addr,m,n,label) -- dump addr+m through addr+n, with label */

#include <ctype.h>

dump(addr,m,n,label)
char *addr, *label;
int m, n;
{
    char c, *p = addr + m, *q = addr + n;  int i;
    if (!label) label = "";
    printf("%s ---------------------------------------\n", label);
    while (p <= q)  {
	printf("\t%08X (%2d)  %08X  ", p, p - addr, i = * (int*) p);
	c = toascii(*p++);  putchar(isprint(c) ? c : '.');
	c = toascii(*p++);  putchar(isprint(c) ? c : '.');
	c = toascii(*p++);  putchar(isprint(c) ? c : '.');
	c = toascii(*p++);  putchar(isprint(c) ? c : '.');
	if (i != 0 && abs(i) <= 10000)  printf("%6d\n",i);
	else putchar('\n');
    }
}
