/*  libc.h -- definitions of standard library functions
 *
 *  This file compensates for some of the variations among Unix systems,
 *  reducing the need for conditional code in source files.
 */


/*  declare funcs by hand, because include files are located inconsistently  */

char *getenv();
char *getwd();
char *malloc(), *realloc();
char *memset(), *memcpy();
char *strcat(), *strncat(), *strchr(), *strrchr(), *strcpy(), *strncpy();
int  strcmp(), strncmp(), strlen();


/*  handle missing functions and symbols under HP-UX  */
 
#ifdef hpux
char *getcwd();
#define SIGCHLD SIGCLD
#define getwd(s) getcwd((s),MAXPATHLEN)
#define psignal(sig,s) fprintf(stderr,"%s: signal %d\n",s,sig)
#endif
