.\"  format with troff or nroff using the -ms macro package
.ds LF \\s7SR\-PORT\\s0	\" document label for the ordering system
.if t .nr PO 1.25i
.TL
Porting the SR Programming Language
.AU
Gregg Townsend
.AI
Department of Computer Science
The University of Arizona
.sp 1
July 21, 1989
.PP
This paper outlines the steps necessary to port the SR system
to a new system architecture.
The reader should first review the companion document
.I "Installing the SR Programming Language,"
which gives an overview of the system and its organization.
.SH
System Requirements
.PP
Any modern Unix system that includes a Berkeley-style
.I socket (2)
interface will meet SR's software requirements fairly well.
SR makes these assumptions about the hardware environment:
.DS
Memory is addressable at the byte level; characters are 8 bits, ASCII.
Integers and all pointer types are 32 bits.
Pointers can be calculated and altered using integer arithmetic.
User stacks can be switched by assembly code.
.DE
.PP
The first three of these assumptions pervade the system.
Context switching is localized to
.B rts/process.c
and the assembly code described below.
Dependencies on Berkeley networking are concentrated mostly in
.B rts/socket.c
and
.B rts/srx.c .
.SH
Porting the C Code
.PP
The present SR system has been built in several different environments.
It is intended to compile without warning messages under
compilers designed for either K&R or ANSI C.
Configure the system according to the installation guide,
then run
.B "make \-k"
and see how many errors result.
.PP
If any errors occur,
you will need to modify the source code.
Our preference is to try first for a portable solution;
or, failing that, to isolate the code in a machine-specific
.B #ifdef .
Pervasive problems can sometimes be handled by modifying
.B libc.h
in the main directory.
.SH
Writing the Assembly Language Code
.PP
Each SR virtual machine is implemented as a single Unix process,
with the machines communicating via sockets.
Within a virtual machine, SR implements a lightweight process facility.
Assembly code to switch contexts is required for each new machine;
scheduling decisions are handled in the existing C code.
.PP
In the
.B rts
subdirectory,
there is a
.B .s
file of assembly code for each different environment.
When SR is built, the correct file is selected by running
.B machine.c
through the C preprocessor and directing the output to
.B machine.s .
A new port will require an additional test in
.B machine.c ,
and a new
.B .s
file of assembly code.
.PP
Three entry points must be supplied for creating, switching,
and checking process contexts.
A ``context'' is just a block of memory containing stack space,
saved registers, and whatever else is necessary.
The C code never looks inside a context array
and doesn't care how it's laid out.
The existing
.B .s
files give some examples for different architectures.
.br
.ne  8
.LP
The needed entry points are:
.RS
.LP
.nf
.ta 20n
\fBsr_build_context\fP (entry, context, size, arg1, arg2, arg3, arg4)
void (*entry)();	/* \fIentry point of function to be called\fP */
char *context;	/* \fIcontext array\fP */
int size;	/* \fIsize of context array, in bytes\fP */
int arg1,... arg4;	/* \fIarguments to be passed to the entry point\fP */
.fi
.IP
Initialize a context array so that, when activated by
.B sr_chg_context ,
it will call the function specified by
.I entry
with the four supplied arguments.
(We assume that no problems arise from possibly calling a C function
with too many arguments.)
The called function is never expected to return;
if it does, a stack underflow abort should occur (see below).
.IP
The context need not be set up so that
.B sr_chg_context
invokes
.I entry
directly;
for example, in the
.B mips.s
code, it proved easiest to plant the address of some additional assembly code
to invoke the desired function when triggered.
.LP
.nf
\fBsr_chg_context\fP (context)
char *context;	/* \fIcontext array\fP */
.fi
.IP
Suspend execution of the current lightweight process
in favor of the one identified by
.I context .
Generally, this means saving one set of registers
(including stack and frame pointers)
and restoring another.
It is only necessary to save those registers that the C compiler
expects to be saved across function calls.
.B sr_chg_context
is always called explicitly by the SR runtime system,
never by random events such as interrupts.
.IP
The first time
.B sr_chg_context
is called, the program is using its original C stack.
After that, it will be executing in a context created by
.B sr_build_context .
.LP
.nf
\fBsr_check_stack\fP ()
.fi
.IP
Check that the current stack has not overflowed its bounds.
This routine is called by the runtime system as a sanity check.
.IP
.B sr_check_stk
is called only when executing in an
.B sr_build_context
context.
.RE
.LP
For all three functions, error conditions should be handled by calling
one of the C functions
.B sr_stk_overflow ,
.B sr_stk_underflow ,
or
.B sr_stk_corrupted
as appropriate.
It is a good idea to check the integrity of a new context,
if possible,
before switching to it.
.SH
Integrating and Testing the Assembly Code
.PP
Place the new assembly code in a new
.B .s
file in the
.B rts
subdirectory along with all the others.
Add a test in
.B machine.c
to select the appropriate file.
Note that the Makefile uses
.I cc (1)
for the selection, but
.I as (1)
for the actual assembly.
.PP
The
.B csw
program is provided for testing assembly code in a simpler environment
than that of SR.
Type
.B "make csw"
to build this test program.
When run,
.B csw
should produce output that is identical with the file
.B csw.stdout .
.SH
System Testing
.PP
Initial testing can be performed using the
.B quick
and
.B examples
subdirectories of the verification suite
(\fBvsuite\fP)
provided with the SR source code.
To run these tests, enter
``\fBsrv/srv quick examples\fP''.
.PP
For a port to a new architecture, further testing is in order.
Be sure to get and run the full verification suite as described in the
installation guide.
.SH
Communication
.PP
If you decide to attempt a port,
please let us know and keep us informed of your progress.
We'll try to assist by answering questions and offering suggestions.
Send email to
.B "sr-project@Arizona.EDU"
or
.B "uunet!arizona!sr-project" .
.br
.ne 5
.PP
If you succeed with the port,
please send us a copy of your changes
for possible inclusion in future versions of SR.
.PP
Good luck!
