#  srv code -- find and follow Script files in verification suite

# start at the top of the vsuite
cd $SRDIR/vsuite

# find all the Script files in the named subdirectories (or all, if none given).
# pipe through "sed" to remove leading and trailing noise.
# read the results to drive a loop.

find ${*-*} -name Script -print \
| sed -e 's!\./!!' -e 's!/Script!!' \
| while read subd
do
    # echo subdirectory and go there.  enable the "rm" command.
    echo "$subd:"
    cd $SRDIR/vsuite/$subd
    rm=rm

    # loop reading the Script file and process each line.
    while read code verb args		# reading <Script -- redirected below
    do
	# skip comments or empty line
	case x$code in
	    x | x#*)	continue;;
	    *)		;;
	    esac

	# echo if tracing was set
	$trace " " "$code" "$verb" "$args"

	# process certain command verbs specially:
	#    use appropriate versions of SR system components
	#    treat "run" as a special case macro
	#    honor "rm" only if not disabled by earlier errors
	case $verb in
	    sr)      $sr  $ec $args >Compiler.out 2>&1;;
	    srl)     $srl $er $args >Linker.out   2>&1;;
	    srm)     $srm     $args >Maker.out    2>&1;;
	    srgrind) $srgrind $args >Grinder.out  2>&1;;
	    srtex)   $srtex   $args >Texer.out    2>&1;;
	    run)
		# check args to set stdin and stdout
		case x$args in
		    x | x-*)		# no arguments, or "-" is first
			ifile=/dev/null
			ofile=No_input;;
		    *)			# arguments present
			set $args
			ifile=$1	 	# use first as file name
			ofile=$1
			shift
			args="$*";;		# pass the rest to the program
		    esac
		# run a.out and compare output if normal exit
		if a.out <$ifile >$ofile.out 2>&1 $args
		    then verb=CMP; cmp -s $ofile.std $ofile.out
		    else (exit $?)	# sets a.out status in $? after the if
		    fi;;

	    rm)     $rm $args;;			# special case rm
	    *)      eval $verb "$args";;	# unrecognized, just execute it
	    esac
	# save result
	result=$?

	# check if result was what we expected
	case $verb$result in
	    $verb$code)			# yes, back to top of loop
		continue;;
	    CMP1)			# no, output differed
		$NECHO "    output differs";;
	    *) 				# no, other problem
		$NECHO "    expected $code, got $result"
		case $result in		# diagnose if known
		    132)  $NECHO ' (illegal instruction)';;
		    138)  $NECHO ' (bus error)';;
		    139)  $NECHO ' (segmentation violation)';;
		    esac;;
	    esac

	rm=:			# disable rm due to unexpected results
	case $verb in
	    run | CMP)
		echo " from a.out <$ifile";
		continue;;	# continue loop if difference in output
	    *)
		echo " from $verb"
		break;;		# else quit this subdirectory on other error
	    esac

	done <Script

    done  # <|find

exit 0
