/*  srsys.h - used by SR runtime system and by generated C code  */

#define	RTS_OWN  0		/* the RTS owns this block of memory */
#define PROG_OWN 1		/* the program owns block of memory */

enum in_type { CALL_IN, SEND_IN, COCALL_IN, COSEND_IN, REM_COCALL_IN };
enum op_type { PROC_OP, PROC_REP_OP, INPUT_OP, SEMA_OP, END_OP };

typedef unsigned char bool;	/* Boolean value */
typedef unsigned char tindex;	/* index into small tables */
typedef short seq;		/* sequence number */

typedef struct cob_st  *cob;	/* co block */
typedef struct invb_st *invb;	/* invocation block */
typedef struct ocap_st opcap;	/* operation capability */
typedef struct pach_st *pach;	/* packet header */
typedef struct proc_st *proc;	/* process descriptor */
typedef struct remd_st *remd;	/* remote request message descr */
typedef struct rcap_st rescap;	/* resource capability */
typedef struct rint_st *rint;	/* resource instance */
typedef struct sem_st  *sem;	/* semaphore descriptor */

/*
 *	Definitions for I/O support.
 */
#define	READ		0	/* read access mode */
#define	WRITE		1	/* write access mode -- truncate on open */
#define	READ_WRITE	2	/* read and write access mode -- no trunc */

#define	ABSOLUTE	0	/* seek offset relative to begin of file */
#define	RELATIVE	1	/* seek offset relative to current position */
#define	EXTEND		2	/* seek offset relative to end of file */

#define	STDIN		0	/* standard input file */
#define	STDOUT		1	/* standard output file */
#define	STDERR		2	/* standard error output file */
#define	NULL_FILE	(-1)	/* file on which all operations are error */
#define	NOOP_FILE	(-2)	/* file on which all operations are no-op */


/* RTS packet types -- also see PROTO_VER in rts/netw.h if changing these */

enum	ms_type	{
	MSG_BAD,		/* error */
	MSG_NONE,		/* no packet available */
	MSG_EOF,		/* EOF on socket */
	MSG_HELLO,		/* VM signon */
	MSG_EXIT,		/* request for global termination */
	REQ_LOCVM,  ACK_LOCVM,	/* specify location for VM */
	REQ_CREVM,  ACK_CREVM,	/* create VM */
	REQ_FINDVM, ACK_FINDVM,	/* find socket of VM */
	REQ_CREATE, ACK_CREATE,	/* create on remote VM */
	REQ_INVOKE, ACK_INVOKE,	/* invoke on remote VM */
	REQ_DESTROY,ACK_DESTROY,/* destroy on remote VM */ 
	REQ_DESTVM, ACK_DESTVM,	/* destroy a VM itself */
	REQ_CALLME, ACK_CALLME,	/* ask another VM to initiate contact */
	};

struct	pach_st	{	/* packet header */
	tindex	origin;		/* originating machine */
	tindex	dest;		/* destination machine */
	short	size;		/* size (in bytes) of the entire packet */
	enum	ms_type	type;	/* message type */
	remd	rem;		/* pending request message descriptor */
	};

struct	ocap_st	{	/* operation capability */
	tindex	vm;		/* virtual machine number */
	short	oper_index;	/* index of entry in operation table */
	short	dummy;
	seq	seqn;		/* sequence number */
	};

struct	cii_st	{	/* co invocation information */
	cob	cobp;		/* ptr to co block */
	invb	next;		/* list of completed invocations */
	tindex	arm_num;	/* arm number in co stmt */
	seq	seqn;		/* co block sequence number */
	};

struct	invb_st	{	/* invocation block */
	struct	pach_st	ph;	/* packet header */
	opcap	opc;		/* operation capability */
	enum	in_type	type;	/* invocation type */
	bool	replied;	/* true iff early reply done */
	seq	seqn;		/* invoker process seq num */
	proc	pr;		/* process id of invoker */
	struct	cii_st	co;	/* information for co stmts */
	sem	wait;		/* sem for waiting on call/input to return */
	invb	next;		/* list of pending invocations */
	invb	last;		/* back pointer */
	short	arg_size;	/* size (in bytes) of the argument area */
	short	filler;		/* force mod4 alignment on Sun */
	int	arg_area [1];	/* space for arguments */
	};

struct	rcap_st	{	/* resource capability */
	tindex	vm;		/* virtual machine number */
	seq	seqn;		/* sequence number */
	rint	res;		/* resource instance descriptor */
	opcap	opcap_list [1];	/* list of exported ops */
	};

struct	crb_st	{	/* resource creation request block */
	struct	pach_st	ph;	/* packet header */
	tindex	rpatid;		/* resource pattern table index */
	tindex	vm;		/* virtual machine on which to create */
	rescap	*rcp;		/* ptr to memory area for capability */
	short	rc_size;	/* size of capability area */
	short	crb_size;	/* size of entire CRB (header + arg area) */
	char	arg_area [1];	/* space for arguments */
	};

#define NULL_SEQN 0	/* seqn of null resource or operation capability */
#define NOOP_SEQN 1	/* seqn of noop resource or operation capability */



#ifndef offsetof
#define offsetof(type,id) ((int)(&((type*)0)->id))
#endif

#define fieldsize(type,id) (sizeof(((type*)0)->id))

#define CRB_HEADER_SIZE offsetof(struct crb_st,arg_area[0])
#define RES_CAP_SIZE offsetof(rescap,opcap_list[0])
#define INVOCATION_HEADER_SIZE offsetof(struct invb_st, arg_area[0])
#define OP_CAP_OFFSET offsetof(struct invb_st,opc)
#define OP_CAP_SIZE fieldsize(struct invb_st,opc)


/*  fields within a descriptor  */

#define AD_MAXL -4		/* maximum length, if string */
#define AD_ADDR  0		/* address */
#define AD_SIZE  4		/* size */
#define AD_LB1   8		/* lower bound, if array */
#define AD_UB1  12		/* upper bound, if array */
#define AD_LB2  16		/* second lower bound, if two-dimensional */
#define AD_UB2  20		/* second upper bound, if two-dimensional */
