/* twalk.c */

#include <stdio.h>
#include "srm.h"

extern sc_nodep sc_list;	/* list of system component records (main.c) */
extern char *arg0;		/* for error messages (main.c) */


f_nodelp do_make_ftree(bf_list,scnode)
f_nodelp bf_list;
sc_nodep scnode;
/*
 * Do the dirty work for make_ftree.
 */
{
    sc_nodep *sclt1;

    if (scnode->been_here.flags==0) {
	scnode->next=scnode->file->sc_used;
	scnode->file->sc_used=scnode;
	scnode->been_here.flags=BH1;
	if (scnode->type==SC_SPEC) {
	    bf_list=addfnodel(bf_list,scnode->partner->file);
	    bf_list=do_make_ftree(bf_list,scnode->partner);
	}
	if (scnode->dep)
	    for (sclt1=scnode->dep->l;*sclt1;sclt1++) {
		if ((*sclt1)->file!=scnode->file)
		    scnode->file->dep=addfnodel(scnode->file->dep,(*sclt1)->file);
		bf_list=do_make_ftree(bf_list,*sclt1);
	    }
    }
    return(bf_list);
}


f_nodelp make_ftree(scnode)
sc_nodep scnode;
/*
 * Walk the system component tree starting at node 'mr' and build a file
 * tree that reflects the dependencies of the system components.  Return
 * a list of pointers to all files containing resource bodies.
 */
{
    return(do_make_ftree((f_nodelp)0,scnode));
}


f_nodelp do_f_walk(f_list,fnode)
f_nodelp f_list;
f_nodep fnode;
/*
 * Walk the tree whose root is 'fnode'.  Add a pointer to each fnode
 * visted to 'f_list'.
 */
{
    f_nodep *flt1;

    if (fnode->been_here&BH1) {
	fprintf(stderr,
	    "%s: \"%s\" involved in import/extend cycle\n",
	    arg0,fnode->file);
	exit(1);
    }

    if ((fnode->been_here&BH2)==0) {
	f_list=addfnodel(f_list,fnode);
	fnode->been_here|=BH2;
    }

    if (fnode->dep) {
	fnode->been_here|=BH1;
	for (flt1=fnode->dep->l;*flt1;flt1++)
	    f_list=do_f_walk(f_list,*flt1);
	fnode->been_here&=BH1MASK;
    }

    return(f_list);
}


f_nodelp f_walk(bf_list)
f_nodelp bf_list;
/*
 * Walk the file trees whose roots are pointed to by bf_list.
 */
{
    f_nodep *flt1;
    f_nodelp f_list;

    for (f_list=0,flt1=bf_list->l;*flt1;flt1++)
	f_list=do_f_walk(f_list,*flt1);

    return(f_list);
}
