/*  srm.h - global definitions for srm  */


#include "../libc.h"


#define MF_BANNER "# created by SRM\n"	/* first line of makefile */

#define DEF_MF "Makefile"	/* default makefile-name */
#define DEF_EXEC "a.out"	/* default exec-name */
#define DEF_CMP "cmp -s"	/* default compare function */

#define EV_OPT "SRMOPTS"	/* env var with options */

#define CMD_COMP "sr -c"	/* command to compile */
#define CMD_LINK "srl"		/* command to link */


typedef struct f_node *f_nodep;		/* pointer to file node */
typedef struct sc_node *sc_nodep;	/* pointer to system component node */
typedef struct id_node *id_nodep;	/* pointer to identfier node */
typedef struct f_nodel *f_nodelp;	/* pointer to fnodel */
typedef struct sc_nodel *sc_nodelp;	/* pointer to fnodel */
typedef struct f_nodell *f_nodellp;	/* pointer to fnodel */


struct f_nodel {
    int s;			/* size of list */
    f_nodep *l;			/* zero terminated list of f_nodep */
};

struct sc_nodel {
    int s;			/* size of list */
    sc_nodep *l;		/* zero terminated list of sc_nodep */
};

struct f_nodell {
    int s;			/* size of list */
    f_nodelp *l;		/* zero terminated list of sc_nodep */
};


struct f_node {
    char *file;			/* name of file */

    sc_nodep sc_used;		/* linked list of used sc_nodes */
    f_nodelp dep;		/* list of f_nodes this f_node depends on */

    short been_here;		/* used when traversing file tree */
};

struct id_node {
    char *id;			/* id of interest */
    int line;			/* line of reference in owner's file */

    id_nodep next;		/* pointer to next id_node in list */
};

struct sc_node {
    char *id;			/* id of system_component */

    short type;			/* type of system_component */

    f_nodep file;		/* file containing declaration */
    int line;			/* line of declaration in file */

    id_nodep imp;		/* linked list of imported ids */
    id_nodep ext;		/* linked list of extended ids */

    sc_nodelp dep;		/* list of sc_nodes this sc_node depends on */

    sc_nodep partner;		/* pointer to a related node */

    union {
	short flags;		/* used when traversing system component tree */
	f_nodep file;		/* used when generating makefile */
    } been_here;

    int icnt;			/* number of times imported */
    int ecnt;			/* number of times extended */

    sc_nodep next;		/* pointer to next sc_node in list */
};

#define SC_GLOBAL 1		/* global */
#define SC_ASPEC 2		/* abstract resource */
#define SC_SPEC 3		/* resource spec */
#define SC_BODY 4		/* resource body */

#define BH1 1			/* been here flag 1 */
#define BH1MASK 2		/* been here flag 1 reset mask */
#define BH2 2			/* been here flag 2 */
#define BH2MASK 1		/* been here flag 2 reset mask */


char *findfile();

char *opt_getarg();		/* return next argument */
char *opt_needarg();		/* return next argument or fail */
char opt_getopt();		/* return next option flag */
char **opt_gargv();		/* return current argv */
int opt_gargc();		/* return current argc */

char *addstr();
char **newstrl();
f_nodelp newfnodel();
sc_nodelp newscnodel();
f_nodellp newfnodell();
f_nodelp addfnodel();
sc_nodelp addscnodel();

f_nodelp make_ftree();
f_nodelp f_walk();
