/* srmopts.c */

#include <stdio.h>
#include "srm.h"

extern char *arg0;	/* for error messages (main.c) */


#define SS_ENV 0	/* source the environment string first */
#define SS_ARGV 1	/* source the argv list next */
#define SS_DONE 2	/* only two sources */

int opt_sstate;		/* current source state */
int opt_pstate;		/* current parse state */

char *opt_argv;		/* working pointer into argument string */
char opt_opt;		/* last option returned */

char *opt_enxt;		/* pointer to next field in environ string */

char **opt_anxt;	/* pointer to next field in argv list */
int opt_argc;		/* count of argv[] strings remaining */


opt_init(envs,argc,argv)
char *envs;
int argc;
char **argv;
/*
 * Initialize the option sources.
 *     envs = environment string
 *     argv = command line argument list
 *     argc = count of arguments in list
 */
{
    opt_enxt = envs;
    opt_anxt = argv;
    opt_argc = argc;
    opt_sstate = 0;
    opt_argv = envs;
    opt_pstate = 0;
}


char *opt_getarg()
/*
 * Return the next argument from the current source, 
 * or 0 if the source is exhausted.
 */
{
    char *arg;
    register char c;
    register char *ptr;

    switch (opt_sstate) {
	case SS_ENV:
	    if (opt_enxt==0)
		arg=0;
	    else {
		for (;(c = *opt_enxt)==' ' || c=='\t';opt_enxt++);
		if (*opt_enxt==0)
		    arg=0;
		else {
		    arg=opt_enxt;
		    while ((c = *opt_enxt)!=' ' && c!='\t' && c!=0) 
			if (c=='\"') {
			    while ((c = *(opt_enxt+1))!='\"' && c!=0)
				*(opt_enxt++)=c;
		    	    for (ptr=opt_enxt;(*ptr = *(ptr+2))!=0;ptr++);
			} else if (c=='\'') {
			    while ((c = *(opt_enxt+1))!='\'' && c!=0)
				*(opt_enxt++)=c;
		    	    for (ptr=opt_enxt;(*ptr = *(ptr+2))!=0;ptr++);
			} else
			    opt_enxt++;
		    if (c!=0) 
			*(opt_enxt++)=0;
		}
	    }
	    break;
	case SS_ARGV:
	    if (opt_argc<1)
		arg=0;
	    else {
		arg = *opt_anxt;
		opt_anxt++;
		opt_argc--;
	    }
	    break;
	default:
	    arg=0;
    }
    return(arg);
}


char *opt_needarg(name)
char *name;
/*
 * Return value for an argument that requires one.
 * Display an error message and exit if the source is exhausted.
 */
{
    char *arg;

    /* return rest of current arg word, if any */
    if (opt_pstate == 1 && *opt_argv != '\0')  {
	arg = opt_argv;
	opt_argv = "";
	return(arg);
    }

    /* nothing was there, so get next word */
    if ((arg=opt_getarg())!=0)
	return(arg);

    /* if no next word, abort */
    fprintf(stderr, "%s: missing %s after -%c\n", arg0,name,opt_opt);
    exit(1);
    /*NOTREACHED*/
}


char opt_getopt(opts)
char *opts;
/*
 * Return the next option from the argument source which is
 * in the list of options 'opts'.  Returns 0 if there are
 * no more options.
 */
{
    while(opt_sstate<SS_DONE) {
	switch (opt_pstate) {
	    case 0:
		if ((opt_argv=opt_getarg())==0) {
		    opt_sstate++;
		    break;
		}
		if (*opt_argv=='-' && *(opt_argv+1)!=0) {
		    opt_pstate=1;
		    opt_argv++;
		} else {
		    switch (opt_sstate) {
			case SS_ENV:
			    if (*opt_argv!=0) {
				fprintf(stderr,
				    "%s: error in environment string \"%s\"\n",
				    arg0,opt_argv);
			    }
			    break;
	 		case SS_ARGV:
			    opt_anxt--;
			    opt_argc++;
			    break;
		    }
		    opt_sstate++;
		}
		break;
	    case 1:
		if ((opt_opt = *opt_argv)==0) {
		    opt_pstate=0;
		} else if (strchr(opts,opt_opt)!=0) {
		    opt_argv++;
		    return(opt_opt);
		} else {
		    fprintf(stderr, "%s: unknown option \"-%c\"\n",
			arg0,opt_opt);
		    exit(1);
		}
		break;
	    default:
		opt_sstate=SS_DONE;
	}
    }
    return(0);
}


char **opt_gargv()
/*
 * Return the current value of 'argv'
 */
{
    return(opt_anxt);
}


opt_gargc()
/*
 * Return the current value of 'argc'
 */
{
    return(opt_argc);
}
