/*  srm - a makefile generator for SR programs
 *  Greg Whitehead, UC Davis, 7-22-87
 *
 *  main.c
 */

#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>	/* needed by HP-UX */
#include <sys/file.h>
#include "../config.h"
#include "../paths.h"
#include "../util.h"
#include "srm.h"

extern char opt_opt;	/* last option returned (opts.c) */
extern FILE *yyin;	/* file descriptor to scan (lex.yy.c) */
extern int fill_pos;	/* current position on line (fill.c) */

sc_nodep sc_list=0;	/* linked list of system component records */

char *arg0;		/* pointer to argv[0] for error msgs */

short verbose = 0;	/* print interesting stuff */


main(argc,argv)
int argc;
char **argv;
{
    static char *sc_name[] = {		/* for displaying sc_node data */
	"global",
	"abstract resource",
	"resource spec",
	"resource body"
    };

    short execmake = 0;			/* exec make(1) on successful exit */
    short smart = 0;			/* check .i for changes */

    char *main_res = 0;			/* main resource */
    char *option_inter = 0;		/* optional interface dir loc */
    char *comp_opt = 0;			/* options for compilation */
    char *link_opt = 0;			/* options for linking */
    char *run_opt = 0;			/* options for MAKE RUN */
    char *cleanx_opt = 0;		/* optional files for MAKE CLEANX */
    char *exec_opt = 0;			/* optional make targets for -G */
    char *exec_name = 0;		/* executable name */

    sc_nodep main_resp = 0;		/* pointer to main resource */

    f_nodelp bf_list = 0;		/* list of files with used bodies */
    f_nodelp c_list = 0;		/* list of files in compile order */
    sc_nodelp l_list = 0;		/* list of resources in link order */

    char *inter_path = 0;		/* path to files in interface dir */

    char *mf_name = 0;			/* name of makefile to create */
    FILE *mfd = 0;			/* file stream for makefile */

    char *smart_cmp = 0;		/* smart compare function */

    char **cmd_line;			/* everlasting ptr to argv */

    char **exec_arg;			/* argv pointer for execv */

    sc_nodep sct1, sct2;		/* tmp sc_node pointers */
    sc_nodep *sclt1, *sclt2;		/* tmp sc_node list pointers */
    id_nodep idt1, idt2, idt3, idt4;	/* tmp id_node pointers */
    f_nodep *flt1, *flt2;		/* tmp f_node list pointers */
    char *ct1, *ct2;			/* tmp char pointers */
    char **clt1;			/* tmp char list pointers */

    char buff[80];			/* one line buffer */


    /*
     * Set up "cmd_line" and "arg0".
     */
    cmd_line = argv;
    if (arg0 = strrchr(*argv,'/'))
	arg0++;
    else
	arg0 = *argv;
    xprefix = arg0;
    argv++;
    argc--;


    /*
     * Check arguments.
     */
    opt_init(getenv(EV_OPT),argc,argv);
    while (opt_getopt("forICLRZGgvSs")!=0) {
	switch (opt_opt) {
	    case 'f':
		mf_name=opt_needarg("makefile-name");
		if (strcmp(mf_name,"-")==0) 
		    mfd = stdout;
		else
		    nosrfile(mf_name,"makefile-name");
		break;
	    case 'o':
		exec_name=opt_needarg("exec-name");
		nosrfile(exec_name,"exec-name");
		break;
	    case 'r':
		main_res=opt_needarg("resource");
		break;
	    case 'I':
		option_inter=opt_needarg("Interfaces directory");
		nosrfile(option_inter,"Interfaces directory");
		break;
	    case 'C':
		comp_opt=opt_needarg("SR options");
		break;
	    case 'L':
		link_opt=opt_needarg("SRL options");
		break;
	    case 'R':
		run_opt=opt_needarg("RUN arguments");
		break;
	    case 'Z':
		cleanx_opt=opt_needarg("file names");
		break;
	    case 'G':
		exec_opt=opt_needarg("make(1) arguments");
	    case 'g':
		execmake = 1;
		break;
	    case 'v':
		verbose = 1;
		break;
	    case 'S':
		smart_cmp=opt_needarg("compare function");
	    case 's':
		smart = 1;
		break;
	}
    } 
    argv=opt_gargv();
    argc=opt_gargc();


    if (mf_name==0)			/* default makefile-name */
	mf_name = DEF_MF;

    if (mfd==0) {
	if (mfd=fopen(mf_name,"r")) {
	    if (fgets(buff,80,mfd)!=0 && strcmp(MF_BANNER,buff)!=0) {
		fprintf(stderr,
	"%s: \"%s\" exists and was not created by SRM - will not overwrite\n",
		    arg0,mf_name);
		exit(1);
	    }
	    fclose(mfd);
	}
	mfd=0;
    }

    if (exec_name==0)			/* default exec-name */
	exec_name = DEF_EXEC;

    if (option_inter) 
	inter_path=addstr(salloc(option_inter),"/");
    else 
	inter_path=salloc("");
    inter_path=addstr(inter_path,INTER_DIR);
    inter_path=addstr(inter_path,"/");

    if (smart_cmp==0)			/* default compare function */
	smart_cmp = DEF_CMP;


    /*
     * Invoke lexsr() on each source file, thus building the list
     * of system component records 'sc_list'.
     */
    if (argc < 1)
	while (ct1 = findfile())
	    buildlist(ct1);
    else
	while (argc > 0)  {
	    if (!strtail(*argv,SOURCE_SUF)) {
		fprintf(stderr,
		    "%s: source-name \"%s\" is not of the form file%s\n",
		    arg0,*argv,SOURCE_SUF);
		exit(1);
	    }
	    buildlist(*argv);
	    argc--;
	    argv++;
	}


    /*
     * Construct a forest of system component nodes that represents the
     * necessary compile order.  A resource's spec must be compiled before
     * its body, and the specs of imported resources must be compiled before
     * their import statements.  Also, construct a body node for each resource
     * that has a concrete spec but no body, and move all of the imports/extends
     * to the new body node.
     */
    for (sct1=sc_list;sct1;sct1=sct1->next) {
	idt3=idt4=0;
	for (sct2=sc_list;sct2;sct2=sct2->next) if (sct2!=sct1) {
	    if (strcmp(sct1->id,sct2->id)==0) {
		if ((sct1->type==SC_SPEC || sct1->type==SC_ASPEC) &&
		  sct2->type==SC_BODY) {
		   if (sct1->partner || sct2->partner) {
			fprintf(stderr,
			    "%s: \"%s\" line %d: \"%s\" multiply defined\n",
			    arg0,sct1->file->file,sct1->line,sct1->id);
			exit(1);
		   }
		   if (sct1->file==sct2->file && sct1->line>sct2->line) {
			fprintf(stderr,
    "%s: \"%s\" line %d: resource spec for \"%s\" must precede separate body\n",
			    arg0,sct1->file->file,sct1->line,sct1->id);
			exit(1);
		    }
		    sct1->type=SC_SPEC;
		    sct2->dep=newscnodel(sct2->dep,sct1);
		    sct1->partner=sct2;
		    sct2->partner=sct1;
		} else if (sct1->type!=SC_BODY || (sct2->type!=SC_SPEC &&
		  sct2->type!=SC_ASPEC)) {
		    fprintf(stderr,
			"%s: \"%s\" line %d: \"%s\" multiply defined\n",
			arg0,sct1->file->file,sct1->line,sct1->id);
		    exit(1);
		}
	    }
	    if (sct2->type!=SC_BODY) {
		for (idt1=sct1->imp,idt2=0;idt1;idt2=idt1,idt1=idt1->next)
		    if (strcmp(idt1->id,sct2->id)==0) {
			if (sct1->file==sct2->file && idt1->line<sct2->line) { 
			    fprintf(stderr,
	"%s: \"%s\" line %d: imported \"%s\" must precede import statement\n",
				arg0,sct1->file->file,idt1->line,sct2->id);
			    exit(1);
			}
			sct1->dep=newscnodel(sct1->dep,sct2);
			sct2->icnt++;
			if (idt2)
			    idt2->next=idt1->next;
			else
			    sct1->imp=idt1->next;
			idt1->next=idt3;
			idt3=idt1;
			break;
		    }
		for (idt1=sct1->ext,idt2=0;idt1;idt2=idt1,idt1=idt1->next)
		    if (strcmp(idt1->id,sct2->id)==0) {
			if (sct1->file==sct2->file && idt1->line<sct2->line) {
			    fprintf(stderr,
	"%s: \"%s\" line %d: extended \"%s\" must precede extend statement\n",
				arg0,sct1->file->file,idt1->line,sct2->id);
			    exit(1);
			}
			sct1->dep=newscnodel(sct1->dep,sct2);
			sct2->ecnt++;
			if (idt2)
			    idt2->next=idt1->next;
			else
			    sct1->ext=idt1->next;
			idt1->next=idt4;
			idt4=idt1;
			break;
		    }
	    }
	}
	if (sct1->imp)
	    for (idt1=sct1->imp;idt1;idt1=idt1->next)
		fprintf(stderr,
		    "%s: \"%s\" line %d: \"%s\" imported but undefined\n",
		    arg0,sct1->file->file,idt1->line,idt1->id);
	if (sct1->ext)
	    for (idt1=sct1->ext;idt1;idt1=idt1->next)
		fprintf(stderr,
		    "%s: \"%s\" line %d: \"%s\" extended but undefined\n",
		    arg0,sct1->file->file,idt1->line,idt1->id);
	if (sct1->imp || sct1->ext)
	    exit(1);
	else {
	    sct1->imp=idt3;
	    sct1->ext=idt4;
	}
	if (sct1->type==SC_SPEC && sct1->partner==0) {
	    sct2=(sc_nodep)alloc(sizeof(struct sc_node));
	    *sct2= *sct1;
	    sct2->type=SC_BODY;
	    sct2->icnt=0;
	    sct2->ecnt=0;
	    sct2->next=sct1->next;
	    sct1->next=sct2;
	    sct1->imp=0;
	    sct1->ext=0;
	    sct1->dep=0;
	    sct1->partner=sct2;
	    sct2->partner=sct1;
	 }
    }


    /*
     * Display some information if verbose is set.
     */
    if (verbose)
	for (sct1=sc_list;sct1;sct1=sct1->next) {
	    printf("\nid: %s (%s)\n  file: %s (line %d)\n",
		sct1->id,sc_name[sct1->type-1],sct1->file->file,sct1->line);
	    fill_pos=0;
	    fill0(stdout,"  import list:");
	    if (sct1->imp)
		for (idt1=sct1->imp;idt1;idt1=idt1->next)
		    fill1(stdout," %s",idt1->id);
	    printf("\n");
	    fill_pos=0;
	    fill0(stdout,"  extend list:");
	    if (sct1->ext)
		for (idt1=sct1->ext;idt1;idt1=idt1->next)
		    fill1(stdout," %s",idt1->id);
	    printf("\n");
	    fill_pos=0;
	    fill0(stdout,"  dependency list:");
	    if (sct1->dep)
		for (sclt1=(sct1)->dep->l;*sclt1;sclt1++)
		    fill2(stdout," %s(%s)",(*sclt1)->id,
			sc_name[(*sclt1)->type-1]);
	    printf("\n  imported %d time%s\n  extended %d time%s\n",
		sct1->icnt,(sct1->icnt==1)?"":"s",
		sct1->ecnt,(sct1->ecnt==1)?"":"s");
	}


    /*
     * Find the main resource in the forest of system components, and zero
     * all of the next ptrs in preparation for constructing the used lists.
     * Unless otherwise specified with the "-r" option, the first resource
     * that isn't imported/extended is assumed to be the main resource.
     */
    if (main_res) {
	for (sct1=sc_list;sct1;) 
	    if (sct1->type!=SC_BODY && strcmp(sct1->id,main_res)==0) {
		if (sct1->type!=SC_SPEC) {
		    fprintf(stderr,
			"%s: \"%s\" is not a legal main resource\n",
			arg0,sct1->id);
		    exit(1);
		}
		if (sct1->icnt>0) 
		    fprintf(stderr,
			"%s: warning: main resource \"%s\" is imported\n",
			arg0,sct1->id);
		if (sct1->ecnt>0) 
		    fprintf(stderr,
			"%s: warning: main resource \"%s\" is extended\n",
			arg0,sct1->id);
		main_resp=sct1;
		break;
	    } else {
		sct2=sct1->next;
		sct1->next=0;
		sct1=sct2;
	    }
	if (main_resp==0) {
	    fprintf(stderr,
		"%s: can't find main resource \"%s\"\n",
		arg0,main_res);
	    exit(1);
	}
    } else {
	for (sct1=sc_list;sct1;)
	    if (sct1->type==SC_SPEC && sct1->icnt==0 && sct1->ecnt==0) {
		main_res=sct1->id;
		main_resp=sct1;
		break;
	    } else {
		sct2=sct1->next;
		sct1->next=0;
		sct1=sct2;
	    }
	if (main_resp==0) {
	    fprintf(stderr,
		"%s: can't find main resource\n",
		arg0);
	    exit(1);
	}
    }
    while (sct1) {
	sct2=sct1->next;
	sct1->next=0;
	sct1=sct2;
    }


    /*
     * Traverse the tree of system components whose root is the main
     * resource and construct a tree of file dependencies among the
     * file nodes.
     */
    bf_list=make_ftree(main_resp);


    /*
     * Walk the file trees created above and create a list of the file
     * records to be compiled.  Use this list to create a list of the
     * resource records in link order.
     */
    if (c_list=f_walk(bf_list)) {
	for (flt1=c_list->l;*flt1;flt1++)
	    for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		if (sct1->type==SC_BODY && strcmp(sct1->id,main_resp->id))
		    l_list=addscnodel(l_list,sct1);
	l_list=addscnodel(l_list,main_resp);
    }


    /*
     * Display some information if verbose is set.
     */
    if (verbose) {
	printf("\nmain resource: %s\n",main_res);
	for (flt1=c_list->l;*flt1;flt1++) {
	    printf("\nfile: %s\n",(*flt1)->file);
	    fill_pos=0;
	    fill0(stdout,"  used list:");
	    if ((*flt1)->sc_used)
		for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		    fill2(stdout," %s(%s)",sct1->id,sc_name[sct1->type-1]);
	    printf("\n");
	    fill_pos=0;
	    fill0(stdout,"  dependency list:");
	    if ((*flt1)->dep)
		for (flt2=(*flt1)->dep->l;*flt2;flt2++)
		    fill1(stdout," %s",(*flt2)->file);
	    printf("\n");
	}
	printf("\n");
	fill_pos=0;
	fill0(stdout,"compile list:");
	for (flt1=c_list->l;*flt1;flt1++) 
	    fill1(stdout," %s",(*flt1)->file);
	printf("\n");
	fill_pos=0;
	fill0(stdout,"link list:");
	for (sclt1=l_list->l;*sclt1;sclt1++) 
	    fill1(stdout," %s",(*sclt1)->id);
	printf("\n");
	printf("\n\nexec file: %s\n",exec_name);
	printf("\nInterface path: %s\n",inter_path);
	printf("\nMakefile name: %s\n\n",mf_name);
	if (comp_opt)
	    printf("-C: %s\n",comp_opt);
	if (link_opt)
	    printf("-L: %s\n",link_opt);
	if (run_opt)
	    printf("-R: %s\n",run_opt);
	if (cleanx_opt)
	    printf("-Z: %s\n",cleanx_opt);
	if (exec_opt)
	    printf("-G: %s\n",exec_opt);
	else 
	    printf("-g: %s\n\n",(execmake)?"Yes":"No");
    }


    /*
     * Generate makefile.
     */
    if (mfd==0)
	mfd=mustopen(mf_name,"w");

    fprintf(mfd,"%s",MF_BANNER);
    fprintf(mfd,"\n.SUFFIXES:\n.SUFFIXES: .\n");

    /*
     * Link dependencies
     */
    fprintf(mfd,"\nlink: %s\n\n",exec_name);
    fill_pos=0;
    fill1(mfd,"%s:",exec_name);
    for (flt1=c_list->l;*flt1;flt1++)
	for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
	    switch (sct1->type) {
		case SC_GLOBAL:
		case SC_ASPEC:
		case SC_SPEC:
		    fill3(mfd," %s%s%s",inter_path,sct1->id,INTER_SUF);
		    break;
		case SC_BODY:
		    fill3(mfd," %s%s%s",inter_path,sct1->id,BODY_SUF);
		    fill1(mfd," %s.o",sct1->id);
		    break;
	    }
    fprintf(mfd,"\n\t%s",CMD_LINK);
    fill_pos=TAB_WIDTH+sizeof(CMD_LINK)-1;
    if (smart) 
	fill0(mfd," -w");
    if (option_inter) 
	fill1(mfd," -I %s",option_inter);
    if (link_opt) 
	fill1(mfd," %s",link_opt);
    fill1(mfd," -o %s",exec_name);
    for (sclt1=l_list->l;*sclt1;sclt1++) 
	fill1(mfd," %s",(*sclt1)->id);

    /*
     * Compile dependencies
     */
    fill_pos=0;
    fill0(mfd,"\n\ncompile:");
    for (flt1=c_list->l;*flt1;flt1++)
	for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
	    switch (sct1->type) {
		case SC_GLOBAL:
		case SC_ASPEC:
		case SC_SPEC:
		    fill3(mfd," %s%s%s",inter_path,sct1->id,INTER_SUF);
		    break;
		case SC_BODY:
		    fill3(mfd," %s%s%s",inter_path,sct1->id,BODY_SUF);
		    fill1(mfd," %s.o",sct1->id);
		    break;
	    }

    /*
     * Handle each source file in turn
     */ 
    for (flt1=c_list->l;*flt1;flt1++)
	if ((*flt1)->sc_used) {
	    fprintf(mfd,"\n\n");
	    /*
	     * Dependents of file
	     */
	    fill_pos=0;
	    for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		switch (sct1->type) {
		    case SC_GLOBAL:
		    case SC_ASPEC:
		    case SC_SPEC:
			fill3(mfd,"%s%s%s ",inter_path,sct1->id,INTER_SUF);
			break;
		    case SC_BODY:
			fill3(mfd,"%s%s%s ",inter_path,sct1->id,BODY_SUF);
			fill1(mfd,"%s.o ",sct1->id);
			break;
		}
	    /*
	     * Dependency on file
	     */
	    fill1(mfd,": %s",(*flt1)->file);
	    /*
	     * Dependencies on things in other files
	     */
	    for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		if (sct1->dep)
		    for (sclt2=sct1->dep->l;*sclt2;sclt2++)
			if ((*sclt2)->file!=sct1->file &&
			  (*sclt2)->been_here.file!= *flt1) {
			    (*sclt2)->been_here.file= *flt1;
			    switch ((*sclt2)->type) {
				case SC_GLOBAL:
				case SC_ASPEC:
				case SC_SPEC:
				    if (smart)
					fill2(mfd," %s%s.x",
					    inter_path,(*sclt2)->id);
				    else
					fill3(mfd," %s%s%s",
					    inter_path,(*sclt2)->id,INTER_SUF);
				    break;
				case SC_BODY:
				    fill1(mfd," %s.o",
					(*sclt2)->id);
				    break;
			    }
			}
	    if (smart)
		for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		    if (sct1->icnt>0 || sct1->ecnt>0)
			switch (sct1->type) {
			    case SC_GLOBAL:
			    case SC_ASPEC:
			    case SC_SPEC:
				fprintf(mfd,"\n\t-@test ! -r");
				fill_pos=TAB_WIDTH+11;
				fill3(mfd," %s%s%s",
				    inter_path,sct1->id,INTER_SUF);
				fill0(mfd," || mv -f");
				fill3(mfd," %s%s%s",
				    inter_path,sct1->id,INTER_SUF);
				fill3(mfd," %s%s%s.old",
				    inter_path,sct1->id,INTER_SUF);
			 	break;
			}
	    fprintf(mfd,"\n\t%s",CMD_COMP);
	    fill_pos=TAB_WIDTH+sizeof(CMD_COMP)-1;
	    if (smart) 
		fill0(mfd," -w");
	    if (option_inter) 
		fill1(mfd," -I %s",option_inter);
	    if (comp_opt) 
		fill1(mfd," %s",comp_opt);
	    fill1(mfd," %s",(*flt1)->file);
	    if (smart)
		for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		    if (sct1->icnt>0 || sct1->ecnt>0)
			switch (sct1->type) {
			    case SC_GLOBAL:
			    case SC_ASPEC:
			    case SC_SPEC:
				fprintf(mfd,"\n\t-@( test -f");
				fill_pos=TAB_WIDTH+11;
				fill2(mfd," %s%s.x",
				    inter_path,sct1->id);
				fill0(mfd," -a -r");
				fill3(mfd," %s%s%s",
				    inter_path,sct1->id,INTER_SUF);
				fill0(mfd," -a -r");
				fill3(mfd," %s%s%s.old ",
				    inter_path,sct1->id,INTER_SUF);
				fill1(mfd," && %s",smart_cmp);
				fill3(mfd," %s%s%s",
				    inter_path,sct1->id,INTER_SUF);
				fill3(mfd," %s%s%s.old",
				    inter_path,sct1->id,INTER_SUF);
				fill0(mfd," ) || touch");
				fill2(mfd," %s%s.x",
				    inter_path,sct1->id);
				fill0(mfd," ; test ! -f");
				fill3(mfd," %s%s%s.old",
				    inter_path,sct1->id,INTER_SUF);
				fill0(mfd," || rm -f");
				fill3(mfd," %s%s%s.old",
				    inter_path,sct1->id,INTER_SUF);
				break;
			}
	    /*
	     * Dependencies of .x files if smart
	     */
	    if (smart)
		for (sct1=(*flt1)->sc_used;sct1;sct1=sct1->next)
		    if (sct1->icnt>0 || sct1->ecnt>0)
			switch (sct1->type) {
			    case SC_GLOBAL:
			    case SC_ASPEC:
			    case SC_SPEC:
				fprintf(mfd,"\n\n");
				fill_pos=0;
				fill2(mfd,"%s%s.x:",
				    inter_path,sct1->id);
				fill3(mfd," %s%s%s",
				    inter_path,sct1->id,INTER_SUF);
				if (sct1->dep) {
				    for (sclt2=sct1->dep->l;*sclt2;sclt2++)
					if ((*sclt2)->file!=sct1->file)
					    switch ((*sclt2)->type) {
						case SC_GLOBAL:
						case SC_ASPEC:
						case SC_SPEC:
						    fill2(mfd," %s%s.x",
						      inter_path,(*sclt2)->id);
						    break;
					    }
				    fprintf(mfd,"\n\t-@test '$?' =");
				    fill_pos=TAB_WIDTH+13;
				    fill3(mfd," %s%s%s",
					inter_path,sct1->id,INTER_SUF);
				    fill0(mfd," || touch");
				    fill2(mfd," %s%s.x",inter_path,sct1->id);
				}
				break;
			}
	}

    /*
     * Generate run, ls, clean, cleanx, and make targets
     */
    fprintf(mfd,"\n\nrun: %s\n\t",exec_name);
    fill_pos=TAB_WIDTH;
    fill1(mfd,"%s",exec_name);
    if (run_opt) 
	fill1(mfd," %s",run_opt);
    fprintf(mfd,"\n\nls:\n\t");
    fill_pos=TAB_WIDTH;
    fill0(mfd,"@echo");
    for (flt1=c_list->l;*flt1;flt1++) 
	    fill1(mfd," %s",(*flt1)->file);
    fprintf(mfd,"\n\nclean:\n\t");
    fill_pos=TAB_WIDTH;
    inter_path[strlen(inter_path)-1]=0;
    fill1(mfd,"rm -rf %s",inter_path);
    for (sclt1=l_list->l;*sclt1;sclt1++) 
	fill1(mfd," %s.[chso]",(*sclt1)->id);
    fprintf(mfd,"\n\ncleanx: clean\n\t");
    fill_pos=TAB_WIDTH;
    fill1(mfd,"rm -f core %s",exec_name);
    if (cleanx_opt)
	fill1(mfd," %s",cleanx_opt);;
    fprintf(mfd,"\n\nmake:\n\t");
    fill_pos=TAB_WIDTH;
    if (cmd_line)  {
	fill1(mfd,"%s",arg0);
	for (clt1=cmd_line+1;*clt1;clt1++)
	    if (strchr(*clt1,' ')!=0)
		fill1(mfd," \"%s\"",*clt1);
	    else
		fill1(mfd," %s",*clt1);
    }
    fprintf(mfd,"\n");
    
    fclose(mfd);

    if (execmake)
	if (mfd==stdout)
	    mexit("can't exec make when makefile goes to stdout");
	else {
	    exec_arg=newstrl((char**)0,"make");
	    exec_arg=newstrl(exec_arg,"-f");
	    exec_arg=newstrl(exec_arg,mf_name);
	    if (exec_opt)
		for (ct1=exec_opt;ct1;ct1=ct2) {
		    if ((ct2=strchr(ct1,' '))!=0)
			*(ct2++)=0;
		    exec_arg=newstrl(exec_arg,ct1);
		}
	    execv(MKPATH,exec_arg);
	    pexit(MKPATH);
	}

    exit(0);
}


buildlist(file)
char *file;
/*
 * Build a list of system components for a single file.
 */
{
    yyin=mustopen(file,"r");
    if (verbose)
	printf("%s: processing \"%s\"\n",arg0,file);
    lexsr(file);
    fclose(yyin);
}
