/* fill.c */

#include <stdio.h>
#include "../config.h"
#include "srm.h"

int fill_pos;		/* current position on line */


fill0(fd,format)
FILE *fd;
char *format;
/*
 * fprintf(fd,format) without exceeding MAX_COLUMNS chars on one line.
 */
{
    fillroom(fd,strlen(format));
    fprintf(fd,format);
}


fill1(fd,format,str1)
FILE *fd;
char *format, *str1;
/*
 * fprintf(fd,format,str1) without exceeding MAX_COLUMNS chars on one line.
 */
{
    fillroom(fd,strlen(format)-2+strlen(str1));
    fprintf(fd,format,str1);
}


fill2(fd,format,str1,str2)
FILE *fd;
char *format, *str1, *str2;
/*
 * fprintf(fd,format,str1,str2) without exceeding MAX_COLUMNS chars on one line.
 */
{
    fillroom(fd,strlen(format)-4+strlen(str1)+strlen(str2));
    fprintf(fd,format,str1,str2);
}


fill3(fd,format,str1,str2,str3)
FILE *fd;
char *format, *str1, *str2, *str3;
/*
 * fprintf(fd,format,s1,s2,s3) without exceeding MAX_COLUMNS chars on one line.
 */
{
    fillroom(fd,strlen(format)-6+strlen(str1)+strlen(str2)+strlen(str3));
    fprintf(fd,format,str1,str2,str3);
}


fillroom(fd,n)
FILE *fd;
int n;
/*
 * make room for the addition of n characters, updating position counter.
 * starting a new line if MAX_COLUMNS would be exceeded.
 */
{
    if (fill_pos+n>=MAX_COLUMNS && fill_pos) { 
	fprintf(fd,"\\\n");
	fill_pos=n;
    } else
	fill_pos+=n;
}
