/* alloc.c */

#include <stdio.h>
#include "../util.h"
#include "srm.h"

static char *resize();



char *addstr(str,strtoadd)
char *str, *strtoadd;
/*
 * Append 'strtoadd' onto the end of 'str'.
 */
{
    char *ct1;

    if (str==0)
	return(salloc(strtoadd));

    ct1=resize(str,strlen(str)+strlen(strtoadd)+1);
    strcat(ct1,strtoadd);
    return(ct1);
}


char **newstrl(strl,str)
char **strl;
char *str;
/*
 * alloc a new ptr to 'str' in the list of string ptrs 'strl'.
 */
{
    char **clt1;
    int count;

    if (strl==0) {
	clt1=(char **)alloc(2*sizeof(char *));
	clt1[0]=str;
	clt1[1]=0;
	return(clt1);
    }

    count=0;
    for (clt1=strl;*clt1;clt1++) count++;

    clt1=(char **)resize((char *)strl,(count+2)*sizeof(char *));
    clt1[count]=str;
    clt1[count+1]=0;
    return(clt1);
}


f_nodelp newfnodel(fnodel,fnode)
f_nodelp fnodel;
f_nodep fnode;
/*
 * alloc a ptr to 'fnode' in the list of f_node ptrs 'fnodel'.
 */
{
    f_nodelp flt1;

    if (fnodel==0) {
	flt1=(f_nodelp)alloc(sizeof(struct f_nodel));
	flt1->l=(f_nodep *)alloc(2*sizeof(f_nodep));
	flt1->l[0]=fnode;
	flt1->l[1]=0;
	flt1->s=1;
	return(flt1);
    }

    fnodel->l=(f_nodep*)resize((char*)fnodel->l,(fnodel->s+2)*sizeof(f_nodep));
    fnodel->l[fnodel->s]=fnode;
    fnodel->s++;
    fnodel->l[fnodel->s]=0;
    return(fnodel);
}


sc_nodelp newscnodel(scnodel,scnode)
sc_nodelp scnodel;
sc_nodep scnode;
/*
 * alloc a ptr to 'scnode' in the list of sc_node ptrs 'scnodel'.
 */
{
    sc_nodelp sclt1;

    if (scnodel==0) {
	sclt1=(sc_nodelp)alloc(sizeof(struct sc_nodel));
	sclt1->l=(sc_nodep *)alloc(2*sizeof(sc_nodep));
	sclt1->l[0]=scnode;
	sclt1->l[1]=0;
	sclt1->s=1;
	return(sclt1);
    }

    scnodel->l=
	(sc_nodep*)resize((char*)scnodel->l,(scnodel->s+2)*sizeof(sc_nodep));
    scnodel->l[scnodel->s]=scnode;
    scnodel->s++;
    scnodel->l[scnodel->s]=0;
    return(scnodel);
}


f_nodelp addfnodel(flist,fnode)
f_nodelp flist;
f_nodep fnode;
/*
 * Make sure 'fnode' is in the list of f_nodes 'flist' exactly once.
 */
{
    f_nodep *flt1;

    if (flist) {
	flist->l[flist->s]=fnode;
	for (flt1=flist->l;*flt1!=fnode;flt1++);
	flist->l[flist->s]=0;
	if (flt1-flist->l<flist->s)
	    return(flist);
    }
    return(newfnodel(flist,fnode));
}


sc_nodelp addscnodel(sclist,scnode)
sc_nodelp sclist;
sc_nodep scnode;
/*
 * Make sure 'scnode' is in the list of sc_nodes 'sclist' exactly once.
 */
{
    sc_nodep *sclt1;

    if (sclist) {
	sclist->l[sclist->s]=scnode;
	for (sclt1=sclist->l;*sclt1!=scnode;sclt1++);
	sclist->l[sclist->s]=0;
	if (sclt1-sclist->l<sclist->s)
	    return(sclist);
    }
    return(newscnodel(sclist,scnode));
}


static char *resize (a, n)
char *a;
int n;
/*
 * Realloc 'a' to be size 'n'.
 */
{
    a=realloc(a,(unsigned)n);
    if (a==0)
	mexit("realloc failed");
    return(a);
}
