/*  main.c -- main program  */


#include <ctype.h>
#include "globals.h"
#include "funcs.h"
#include "../config.h"
#include "../paths.h"


char version[] = VERSION;	/* SR version number */

short exper = 0;		/* experimental RTS flag */
short dbx = 0;			/* link with debugging lib for dbx */
short errors = 0;		/* number of errors */
short do_time_check = 1;	/* make sure compiled objects are current */

char *Interfaces = INTER_DIR;	/* name of Interfaces directory */
char *exe_file;			/* name of executable file */
char *lib_file = 0;		/* name of object library file */
    
resp res_list = NULL;		/* list of all resource patterns */
		    		/* (main resource heads the list) */

objp obj_list = NULL;		/* list of other object files */
objp obj_tail = NULL;		/* tail of the list */


/* runtime limits */

int trace_flag = 0;			/* trace runtime startups? */
int max_co_stmts = MAX_CO_STMTS;	/* limit on active "co" statements */
int max_classes = MAX_CLASSES;		/* limit on "in" operation classes */
int max_loops = MAX_LOOPS;		/* limit on loops between cswitches */
int max_operations = MAX_OPERATIONS;	/* limit on active operations */
int max_processes = MAX_PROCESSES;	/* limit to number of processes */
int max_rmt_reqs = MAX_RMT_REQS;	/* limit on pending remote requests */
int max_resources = MAX_RESOURCES;	/* limit on active resources */
int max_semaphores = MAX_SEMAPHORES;	/* limit on number of semaphores */
int stack_size = STACK_SIZE;		/* size of a process stack */

static struct lim { char c; int *v; char *s; } limits[] = {
    'C', &max_co_stmts,   "maximum number of active `co' statements",
    'L', &max_loops,      "maximum number of loops before context switch",
    'N', &max_classes,    "maximum number of `in' operation classes",
    'O', &max_operations, "maximum number of active operations",
    'P', &max_processes,  "maximum number of processes",
    'Q', &max_rmt_reqs,   "maximum number of pending remote requests",
    'R', &max_resources,  "maximum number of active resources",
    'V', &max_semaphores, "maximum number of semaphores",
    'S', &stack_size,     "size of a process stack",
    0, 0, 0};



/*  main program  */

main (argc, argv)
int argc;
char *argv[];
{
    int i, c;
    resp res;
    objp obj;
    buffer mesg;
    extern int optind;
    extern char *optarg;

    /* parse command line options. */
    while ((c = getopt(argc,argv,"eglvwI:o:r:C:L:N:O:P:Q:R:V:S:T")) != EOF)
	switch (c)  {

	case 'I':
	    Interfaces = alloc(strlen(optarg)+strlen(INTER_DIR)+2);
	    sprintf(Interfaces,"%s/%s",optarg,INTER_DIR);
	    break;

	case 'o':
	    exe_file = optarg;
	    break;

	case 'r':
	    lib_file = optarg;
	    break;
	    
	case 'e':  exper++;		break;
	case 'g':  dbx++;		break;
	case 'v':  trcexec++;		break;
	case 'w':  do_time_check = 0;	break;
	case 'T':  trace_flag = 1;	break;

	case 'l':  showlimits();	exit(0);

	case 'C':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'V':
	case 'S':
	    setlimit(c,optarg);
	    break;
	
	default:  mexit(
"usage: srl [-eglvwT] [-I dir] [-o file] [-r file] [-CLNOPQRVS size] resource..."
		);
    }

    if (!exe_file)
	exe_file = "a.out";

    xprefix = argv[0];	/* set exit message prefix */
    if (optind >= argc)  mexit ("no resources specified");

    /* select the ones we want */
    while (optind < argc) {
	optarg = argv[optind++];
	if (strtail(optarg,".o") || strtail(optarg,".a")
	|| strncmp(optarg,"-l",2)==0)  {
	    /* file name for loading */
	    obj = (objp) alloc(sizeof(struct obj_st));
	    obj->next = 0;
	    obj->object = optarg;
	    if (obj_tail)
		obj_tail = obj_tail->next = obj;
	    else 
		obj_list = obj_tail = obj;
	} else if (res = res_search (optarg))  {
	    /* resource name found */
	    res->next = res_list;
	    res_list = res;
	}
	else {
	    sprintf (mesg, "unknown resource (%s)", optarg);
	    srl_error(mesg);
	}
    }

    /* make sure everything is up to date and correctly specified */
    check_object ();
    check_main ();

    /* number the resources */
    for (i = 0, res = res_list ; res ; res = res->next)
	res->patnum = i++;

    /* get out early before doing costly bogus link */
    if (errors)  mexit ("linking suppressed");

    /* generate executable(s) */
    gen_config ();	/* gen a.out.o configuration file */
    gen_exe ();	/* Does Not Return! */
    /*NOTREACHED*/
}



/*
 *  Set the value of the limit associated with option character c.
 *  Abort with a diagnostic if the integer is illegal.
 */
void
setlimit (c, s)
char c;
char *s;
{
    int v;
    char *p, temp[100];
    struct lim *l;

    v = 0;
    p = s;
    while (isdigit (*p))
	v = 10 * v + *p++ - '0';
    if (*p != '\0') {
	sprintf (temp, "srl: illegal integer value: -%c %s", c, s);
	mexit (temp);
    }
    for (l = limits; l->v; l++)
	if (c == l->c)  {
	    *l->v = v;
	    return;
	}
    sprintf (temp, "srl: mishandled option -%c", c);
    mexit (temp);
}



/*  List the current runtime limit values.  */

void
showlimits ()
{
    struct lim *l;

    printf ("SR runtime limits:\n");
    for (l = limits; l->v; l++)
	printf ("    -%c %d\t%s\n", l->c, *l->v, l->s);
}



/*  Print a warning message.  */

void
srl_warn (s)
char *s;
{
    fprintf (stderr, "srl warning:  %s\n", s);
}



/*  Print a non-fatal error message.  */

void
srl_error (s)
char *s;
{
    fprintf (stderr, "srl error:  %s\n", s);
    errors++;
}
