/* tokens.h - list of tokens and tree nodes used in the sr compiler
 *
 * usage of fields:
 *	name	token name
 *	rsv	is this a reserved word?
 *	left	usage of left child:  N_NIL, N_NODE, N_SYM, N_CON
 *	right	usage of right child:  N_NIL, N_NODE
 *	prec	precedence in parsing, iff binary operator
 *
 *	If a token never appears in a tree, both left and right are nil.
 *
 *	The "rsv" field helps give better error messages when a reserved word
 *	is used as an identifier.
 *
 *	Note that a few tokens (e.g. TK_AND) can appear either as a symbol
 *	("&") or reserved word ("and");  these tokens are also marked reserved.
 *	Finally note that ERR and EOF get converted to numbers; we'll leave that
 *	alone.
 *
 *	The caller of this file must #define tkmac() as desired.
 */

/* name, reserved?, left, right, precedence */

/* token list terminator; must be first to correspond to 0 return from yylex */
tkmac(NOTATOKEN,0, N_NIL,  N_NIL,  0)

/* tokens representing unary operators */
tkmac(CAST,     0, N_SYM,  N_NODE, 0)		/* l: dest type */
tkmac(NOT,      1, N_NODE, N_NIL,  0)
tkmac(UMINUS,	0, N_NODE, N_NIL,  0)
tkmac(ADDR,	0, N_NODE, N_NIL,  0)

/* binary operators */
tkmac(OR,       1, N_NODE, N_NODE, 1)
tkmac(XOR,      1, N_NODE, N_NODE, 1)
tkmac(AND,	1, N_NODE, N_NODE, 2) /* "&", "and" */
tkmac(EQ,	0, N_NODE, N_NODE, 3)
tkmac(NE,	0, N_NODE, N_NODE, 3)
tkmac(GE,	0, N_NODE, N_NODE, 3)
tkmac(GT,	0, N_NODE, N_NODE, 3)
tkmac(LE,	0, N_NODE, N_NODE, 3)
tkmac(LT,	0, N_NODE, N_NODE, 3)
tkmac(RSHIFT,	0, N_NODE, N_NODE, 4)
tkmac(LSHIFT,	0, N_NODE, N_NODE, 4)
tkmac(CONCAT,	0, N_NODE, N_NODE, 5)
tkmac(MINUS,    0, N_NODE, N_NODE, 5)
tkmac(PLUS,     0, N_NODE, N_NODE, 5)
tkmac(DIV,      0, N_NODE, N_NODE, 6)
tkmac(MOD,      0, N_NODE, N_NODE, 6)
tkmac(STAR,     0, N_NODE, N_NODE, 6)	/* multiply, or ARB (q.v.) */

/* keywords (except those above) */
/* EOF and ERR map directly into integer constants */
tkmac(AF,	1, N_NIL,  N_NIL,  0)
tkmac(ANY,	1, N_NIL,  N_NIL,  0)
tkmac(BODY,	1, N_NIL,  N_NIL,  0)
tkmac(BOOL,	1, N_NIL,  N_NIL,  0)
tkmac(BY,	1, N_NIL,  N_NIL,  0)
tkmac(CALL,	1, N_NODE, N_NIL,  0)	/* l: TK_INVOKE node */
tkmac(CAP,	1, N_NIL,  N_NIL,  0)
tkmac(CHAR,	1, N_NIL,  N_NIL,  0)
tkmac(CO,	1, N_NIL,  N_NIL,  0)
tkmac(CONST,	1, N_NODE, N_NODE, 0)	/* variant of ASSIGN node */
tkmac(CREATE,	1, N_NODE, N_NODE, 0)	/* under ASSIGN; l:denot r:on node */
tkmac(DESTROY,	1, N_NODE, N_NIL,  0)	/*l:cap of resource to destroy*/
tkmac(DO,	1, N_NIL,  N_NIL,  0)
tkmac(DOWNTO,	1, N_NIL,  N_NIL,  0)
tkmac(ELSE,	1, N_NIL,  N_NIL,  0)
tkmac(END,	1, N_NIL,  N_NIL,  0)
tkmac(ENUM,	1, N_NIL,  N_NIL,  0)
tkmac(EXIT,	1, N_NIL,  N_NIL,  0)
tkmac(EXTEND,	1, N_NIL,  N_NIL,  0)
tkmac(EXTERNAL,	1, N_NIL,  N_NIL,  0)
tkmac(FA,	1, N_NIL,  N_NIL,  0)
tkmac(FI,	1, N_NIL,  N_NIL,  0)
tkmac(FILE,	1, N_NIL,  N_NIL,  0)	/* could combine with FILE_CON */
tkmac(FINAL,	1, N_NIL,  N_NIL,  0)
tkmac(GLOBAL,	1, N_NIL,  N_NIL,  0)
tkmac(IF,	1, N_NIL,  N_NIL,  0)
tkmac(IMPORT,	1, N_NIL,  N_NIL,  0)
tkmac(IN,	1, N_NIL,  N_NIL,  0)
tkmac(INITIAL,	1, N_NIL,  N_NIL,  0)
tkmac(INT,	1, N_NIL,  N_NIL,  0)
tkmac(NEW,	1, N_SYM,  N_NODE, 0)	/* new(type) */
tkmac(NEXT,	1, N_NIL,  N_NIL,  0)
tkmac(NI,	1, N_NIL,  N_NIL,  0)
tkmac(NOOP,	1, N_NIL,  N_NIL,  0)
tkmac(NULL,	1, N_NIL,  N_NIL,  0)
tkmac(OC,	1, N_NIL,  N_NIL,  0)
tkmac(OD,	1, N_NIL,  N_NIL,  0)
/* TK_ON: always r side of TK_CREATE. l:null|vmcap r:arglist */
tkmac(ON,	1, N_NODE, N_NODE, 0)
tkmac(OP,	1, N_NIL,  N_NIL,  0)
tkmac(OPTYPE,	1, N_NIL,  N_NIL,  0)
tkmac(P,	1, N_NIL,  N_NIL,  0)
tkmac(PROC,	1, N_NIL,  N_NIL,  0)
tkmac(PROCESS,	1, N_NIL,  N_NIL,  0)
tkmac(PTR,	1, N_NODE, N_NIL,  0)
tkmac(REC,	1, N_NIL,  N_NIL,  0)
tkmac(RECEIVE,	1, N_NIL,  N_NIL,  0)	/* this will prob change too */
tkmac(REF,	1, N_NIL,  N_NIL,  0)	/* keep reserved per GRA 13-Nov-87 */
tkmac(REPLY,	1, N_NIL,  N_NIL,  0)
tkmac(RES,	1, N_NIL,  N_NIL,  0)
tkmac(RESOURCE,	1, N_NIL,  N_NIL,  0)
tkmac(RETURN,	1, N_NIL,  N_NIL,  0)
tkmac(RETURNS,	1, N_NIL,  N_NIL,  0)
tkmac(SEM,	1, N_NIL,  N_NIL,  0)
tkmac(SEND,	1, N_NODE, N_NODE, 0)	/* l:INVOKE r: CO_SEND list of IDs */
tkmac(SEPARATE,	1, N_NIL,  N_NIL,  0)
tkmac(SKIP,	1, N_NIL,  N_NIL,  0)
tkmac(SUCHTHAT,	1, N_NIL,  N_NIL,  0)
tkmac(STDERR,	1, N_NIL,  N_NIL,  0)	/* becomes TK_FILE_CONST */
tkmac(STDIN,	1, N_NIL,  N_NIL,  0)	/* becomes TK_FILE_CONST */
tkmac(STDOUT,	1, N_NIL,  N_NIL,  0)	/* becomes TK_FILE_CONST */
tkmac(STOP,	1, N_NIL,  N_NIL,  0)
tkmac(STRING,	1, N_NIL,  N_NIL,  0)
tkmac(TO,	1, N_NIL,  N_NIL,  0)
tkmac(TYPE,	1, N_NIL,  N_NIL,  0)
tkmac(UNION,	1, N_NIL,  N_NIL,  0)	/* not yet recognized or supported */
tkmac(V,	1, N_NIL,  N_NIL,  0)
tkmac(VAL,	1, N_NIL,  N_NIL,  0)
tkmac(VAR,	1, N_NIL,  N_NIL,  0)

/* tokens mapped from keywords and treated as such in some contexts */
tkmac(BOOLEAN,     1, N_CON,  N_NIL,  0)	/* TRUE, FALSE */
tkmac(FILE_CONST,  1, N_CON,  N_NIL,  0)	/* file constants */
tkmac(FILE_NOOP,   1, N_NIL,  N_NIL,  0)
tkmac(FILE_NULL,   1, N_NIL,  N_NIL,  0)
tkmac(OPCAP_NOOP,  1, N_NIL,  N_NIL,  0)
tkmac(OPCAP_NULL,  1, N_NIL,  N_NIL,  0)
tkmac(PTR_NOOP,    1, N_NIL,  N_NIL,  0)
tkmac(PTR_NULL,    1, N_NIL,  N_NIL,  0)
tkmac(RESCAP_NOOP, 1, N_NIL,  N_NIL,  0)
tkmac(RESCAP_NULL, 1, N_NIL,  N_NIL,  0)
tkmac(VMCAP_NOOP,  1, N_NIL,  N_NIL,  0)
tkmac(VMCAP_NULL,  1, N_NIL,  N_NIL,  0)

/* other semantic tokens */
tkmac(COMMA,	0, N_NIL,  N_NIL,  0)
tkmac(SEMICOLON,0, N_NIL,  N_NIL,  0)
tkmac(COLON,	0, N_NIL,  N_NIL,  0)
tkmac(INCREMENT,0, N_NODE, N_NIL,  0)
tkmac(DECREMENT,0, N_NODE, N_NIL,  0)
tkmac(LEFTPAREN,0, N_NIL,  N_NIL,  0)
tkmac(RIGHTPAREN,0,N_NIL,  N_NIL,  0)
tkmac(ARROW,	0, N_NIL,  N_NIL,  0)
tkmac(SQUARE,	0, N_NIL,  N_NIL,  0)
tkmac(ASSIGN,	0, N_NODE, N_NODE, 0)
tkmac(SWAP,	0, N_NODE, N_NODE, 0)
tkmac(LEFTBKET,	0, N_NIL,  N_NIL,  0)
tkmac(RIGHTBKET,0, N_NIL,  N_NIL,  0)
tkmac(PERIOD,	0, N_NODE, N_NODE, 0)	/* l:base address r:field name*/
tkmac(HAT,	0, N_NODE, N_NIL,  0)	/* indirection */
tkmac(LEFTBCE,	0, N_NIL,  N_NIL,  0)
tkmac(RIGHTBCE,	0, N_NIL,  N_NIL,  0)
tkmac(QUESTION,	0, N_NODE, N_NIL,  0)	/* for ? op_name; l:IDENTIFIER*/
tkmac(PARALLEL,	0, N_NIL,  N_NIL,  0)
tkmac(NUMBER,	0, N_CON,  N_NIL,  0)	/* integer literal */
tkmac(CHRLIT,	0, N_CON,  N_NIL,  0)	/* character literal */
tkmac(STRLIT,	0, N_CON,  N_NIL,  0)	/* string literal */
tkmac(IDENTIFIER,0,N_SYM,  N_NIL,  0)


/*  others, not yet completely organized  */

tkmac(LIST,	0, N_NODE, N_NODE, 0)	/* l:item; r:next list node, or NIL */

tkmac(FORMAL,	0, N_SYM, N_NODE, 0)	/* l:sym  r:PBADDR */
tkmac(PBADDR,	0, N_CON, N_NIL,  0)	/* parameter block address */
tkmac(ALOCAL,	0, N_CON, N_NIL,  0)	/* address local n (local holds addr) */

tkmac(INDEX,	0, N_NODE, N_NODE, 0)	/* l:base r:offset */
tkmac(ARB,	0, N_NIL,  N_NIL,  0)	/* "*" as subscript */

/* a list of TK_RANGEs represent multiple dimensions */
tkmac(RANGE,	0, N_NODE, N_NODE, 0)	/* l:lowerbound r:upperbound */

tkmac(LB1,	0, N_SYM,  N_NIL,  0)	/* lower bound of first dimension */
tkmac(LB2,	0, N_SYM,  N_NIL,  0)	/* lower bound of second dimension */
tkmac(UB1,	0, N_SYM,  N_NIL,  0)	/* upper bound of first dimension */
tkmac(UB2,	0, N_SYM,  N_NIL,  0)	/* upper bound of second dimension */

tkmac(RUNTIMESIZE,   0, N_SYM, N_NIL, 0)	/* l:id whose sig to look at */

tkmac(LENGTH,	0, N_NODE, N_NIL,  0)	/* current length of a string */
tkmac(SUBSTR,	0, N_NODE, N_NODE, 0)	/* substring */

tkmac(VECTORIZE,0, N_NODE, N_NODE, 0)
tkmac(CLONE,	0, N_NODE, N_NODE, 0)	/* l: count; r: obj */

/* for the following CO_ ops, l: INVOKE; r: LIST of IDENTIFIERs */
tkmac(CO_CALL,	0, N_NODE, N_NODE, 0)
tkmac(CO_SEND,	0, N_NODE, N_NODE, 0)
tkmac(CO_CALL_COPY_BACK, 0, N_NODE, N_NODE, 0)	/* co_call results */
tkmac(CO_SEND_COPY_BACK, 0, N_NODE, N_NODE, 0)	/* co_send results */



tkmac(INPUT,	0, N_NODE, N_NIL,  0)	/* operation in an input stmt */
tkmac(INVOKE,	0, N_NODE, N_NODE, 0)	/* l:denotation r:parlist */
tkmac(CREVM,	0, N_SYM,  N_NODE, 0)	/* l:vm sym  r:iexpr or null */

tkmac(BLOCK,	0, N_NODE, N_NIL,  0)

/* for associating a class with an input statement in the intermediate code */
tkmac(CLASS,	0, N_NODE, N_NIL,  0)	/* l: class structure */

tkmac(EOF,	0, N_NIL,  N_NIL,  0)	/* used as flag for when EOF ok? */
tkmac(IMPORTED_CONST, 0, N_NODE, N_NIL,  0)	/* l: symtab pointer */

/* This is used only to get the signature of a parameter built when
 * doing type checking on argument list.
 * just like TK_IDENTIFIER node -- only significant difference:
 *    SIZE_ARB's not converted to SIZE_UNK with exprs.
 */
tkmac(TEMPLATE,	0, N_SYM, N_NIL,  0)
