/*  temps.c -- allocation and deallocation of temporary stack space  */

#include <ctype.h>
#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"
#include "../util.h"

typedef struct stpos {
    int offset;			/* OFF_UNK if this is a `mark' */
    int size;			/* 0 size is a `mark' */
    struct stpos *nextpos;
} *Stpos;
	
static Stpos freeslots[MAX_PROC];/* lists of freed and allocated slots on the */
static Stpos allocated[MAX_PROC];/* stack, indexed by proc */
static int hwproc;		/* maximum cur_proc seen so far */
	

/* called once before any offsets are assigned */	
void
stack_init()
{
    hwproc = -1;
}


/* Allocate space on the stack for an object of size mysize.
   Return the offset allocated.
*/
int
temp_alloc(mysize)
int mysize;
{
    Stpos s, prev;

    if (cur_proc > hwproc) {
	hwproc = cur_proc;
	freeslots[cur_proc] = (Stpos)alloc(sizeof(struct stpos));
	freeslots[cur_proc]->nextpos = 0;
	allocated[cur_proc] = (Stpos)alloc(sizeof(struct stpos));
	allocated[cur_proc]->nextpos = 0;
    }
    
    /* first see if there is already a spot allocated */
    if (mysize <= 0)
	boom("Zero size allocated");
    mysize = align(mysize);

    for (prev=freeslots[cur_proc], s=prev->nextpos; s; prev=s, s=s->nextpos){
 	if (s->size >= mysize)  {
	    prev->nextpos = s->nextpos;
	    break;
	}
    }
    if (!s) {			/* allocate a new slot */
	s = (Stpos)alloc(sizeof(struct stpos));
	s->offset = max_offset[cur_proc];
	max_offset[cur_proc] += s->size = mysize;
    } else if (s->size > mysize) { /* split the slot */
	Stpos newpos;
	newpos = (Stpos)alloc(sizeof(struct stpos));
	newpos->offset = s->offset;
	newpos->size = mysize;
	s->offset += mysize;
	s->size -= mysize;
	s = newpos;
    }
    s->nextpos = allocated[cur_proc]->nextpos;
    allocated[cur_proc]->nextpos = s;
    return s->offset;
}



/* Free up stack slots in lifo order until _size_ bytes have been freed.
   This, and calls to it, should probably be eliminated someday;
   they should be replaced with stack_dealloc().
*/
void
temp_free(size)
int size;
{
    Stpos s;
    size = align(size);
    while (allocated[cur_proc]->nextpos && size > 0) {
	s = allocated[cur_proc]->nextpos;
	size -= s->size;
	allocated[cur_proc]->nextpos = s->nextpos;
	s->nextpos = freeslots[cur_proc]->nextpos;
	freeslots[cur_proc]->nextpos = s;
	
    }
    if (size > 0)
	boom("temp_free: freed more than allocated");
    if (size < 0)
	boom("temp_free: freed odd-sized slot");
}
