/*  presym.c - initialize predefined symbols  (functions & enums)  */

#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"

static Symptr predef_enum();



/*  table of predefined operations  */

struct pre_op_struct {
    char * p_name;
    Type p_type;
    Predef p_which;
};

#ifdef __STDC__
#define premac(name,type) { #name, type, PRE_ ## name },
#else
#define premac(name,type) { "name", type, PRE_/**/name },
#endif

static struct pre_op_struct pre_ops[] = {
#include "predefs.h"
#undef premac
};



/*  presym() - initialize predefined functions and enums
 *
 *  It might be more flexible to define these using an implicitly imported
 *  SR file;  however, varargs functions and things like new(type) would pose
 *  problems.
 */

void
presym()
{
    Symptr block_sym, op_sym, s;
    struct pre_op_struct *p;

    static char *accessmode_name[] = {"READ", "WRITE", "READWRITE", 0};
    static char *seektype_name[] = {"ABSOLUTE", "RELATIVE", "EXTEND", 0};

    block_sym = st_install("--pre-defined--",K_BLOCK);
    block_sym->s_type = T_PREDEF;

    /* make an st entry for each predefined operation. */
    /* each gets an empty aux table, just as for real operations. */

    for (p = pre_ops; p->p_which != PRE_notapredef; p++) {
	op_sym = st_install(p->p_name, K_PREDEF);
	op_sym->s_type = p->p_type;
	op_sym->s_predef = p->p_which;
	op_sym->s_restrict = R_CALL;
	op_sym->s_tdef = new_symbol(K_NOTAKIND);
    }

    /* install enumeration types for file operations.  */
    accessmode_sym = predef_enum("accessmode", accessmode_name);
    seektype_sym = predef_enum("seektype", seektype_name);

    /* predefine the "vm" pseudo-resource */
    s = st_install("vm",K_VM);
    s->s_type = T_SPEC;
    s->s_size = VMSIZE;

    /* let the symtab routines know we're done */
    note_end_predefs();
}



/*  predef_enum (name, literals) - define enum "name" with the given literals,
 *  returning its symbol table pointer  */

static Symptr
predef_enum(name, lit)
char *name;
char **lit;
{
    Symptr enum_sym, lit_sym;
    int off;

    /* install the enumeration type. */
    enum_sym = st_install(name, K_TYPE);
    enum_sym->s_type = T_ENUM;
    enum_sym->s_tdef = enum_sym;

    /* install the literals and give them values.
     * make tdef for each literal point to the enumeration type.
     */

    off = 0;
    while (*lit) {
	lit_sym = st_install(*lit++, K_LITERAL);
	lit_sym->s_type = T_ENUM;
	lit_sym->s_offset = off++;
	lit_sym->s_tdef = enum_sym;
    }

    return (enum_sym);
}
