/* predefs.h - list of predefined functions
 *
 * This file contains a list of predefs and whether each
 * returns a value; i.e., its type (T_FUNC or T_VOID).
 *
 * The caller must define the macro premac as needed.
 */

/* standard predefined operations */
premac(abs,T_FUNC)
premac(max,T_FUNC)
premac(min,T_FUNC)
premac(low,T_FUNC)
premac(high,T_FUNC)
premac(pred,T_FUNC)
premac(succ,T_FUNC)
premac(lb,T_FUNC)
premac(ub,T_FUNC)
premac(lb1,T_FUNC)
premac(ub1,T_FUNC)
premac(lb2,T_FUNC)
premac(ub2,T_FUNC)
premac(length,T_FUNC)
premac(maxlength,T_FUNC)
premac(free,T_VOID)
premac(locate,T_VOID)
premac(myresource,T_FUNC)
premac(mymachine,T_FUNC)
premac(myvm,T_FUNC)

/* file operations */
premac(open,T_FUNC)
premac(flush,T_VOID)
premac(close,T_VOID)
premac(remove,T_FUNC)
premac(read,T_FUNC)
premac(write,T_VOID)
premac(writes,T_VOID)
premac(get,T_FUNC)
premac(put,T_VOID)
premac(seek,T_FUNC)
premac(where,T_FUNC)

/* argument operations */
premac(numargs,T_FUNC)
premac(getarg,T_FUNC)

/* timer functions */
premac(nap,T_VOID)
premac(age,T_FUNC)

/* for things that aren't predefs. */
/* note: code in predef.c assumes this is the last entry. */
premac(notapredef,T_NOTATYPE)
