/*  logical.c -- generate comparison operations  */

#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"
#include "../srsys.h"

static void gen_test(), gen_cap_cmp();



/* generate code for logical operations
 *
 * Either tlab or flab must be zero.
 * If both are zero then e may be either boolean or integer.
 */
void
gen_logical(e, tlab, flab)
Nodeptr e;
int tlab, flab;
{
    int fall_through;		/* label */

    switch (e->e_op) {
    case TK_IDENTIFIER:
    case TK_INDEX:
    case TK_PERIOD:
    case TK_CALL:
	if (tlab)
	    cprintf("if(%e)goto %g;\n",e,tlab);
	else if (flab)
	    cprintf("if(!%e)goto %g;\n",e,flab);
	break;
    case TK_BOOLEAN:
	if (e->e_i == 0 && flab)
	    cprintf("goto %g;\n",flab);
	else if (e->e_i == 1 && tlab)
	    cprintf("goto %g;\n",tlab);
	break;

    case TK_EQ:	gen_test(e,tlab,flab,"==","!=");  break;
    case TK_NE:	gen_test(e,tlab,flab,"!=","==");  break;
    case TK_GT:	gen_test(e,tlab,flab,">", "<=");  break;
    case TK_GE:	gen_test(e,tlab,flab,">=","<");   break;
    case TK_LT:	gen_test(e,tlab,flab,"<", ">=");  break;
    case TK_LE:	gen_test(e,tlab,flab,"<=",">");   break;

    case TK_NOT:
	if (tlab || flab)
	    gen_logical(e->e_l,flab,tlab);
	else if (e->e_sig->s_type == T_BOOL)
	    cprintf("!%e",e->e_l);
	else
	    cprintf("~%e",e->e_l);
	break;
    case TK_AND:
	if (tlab) {
	    fall_through = NEWLAB;
	    gen_logical(e->e_l, 0, fall_through);
	    gen_logical(e->e_r, tlab, 0);
	    wlab(fall_through);
	} else if (flab) {
	    gen_logical(e->e_l, 0, flab);
	    gen_logical(e->e_r, 0, flab);
	} else if (e->e_sig->s_type == T_BOOL)
	    cprintf("(%e&&%e)",e->e_l,e->e_r);
	else
	    cprintf("(%e&%e)",e->e_l,e->e_r);
	break;
    case TK_OR:
	if (tlab) {
	    gen_logical(e->e_l, tlab, 0);
	    gen_logical(e->e_r, tlab, 0);
	} else if (flab) {
	    fall_through = NEWLAB;
	    gen_logical(e->e_l, fall_through, 0);
	    gen_logical(e->e_r, 0, flab);
	    wlab(fall_through);
	} else if (e->e_sig->s_type == T_BOOL)
	    cprintf("(%e||%e)",e->e_l,e->e_r);
	else
	    cprintf("(%e|%e)",e->e_l,e->e_r);
	break;
    case TK_XOR:
	if (e->e_sig->s_type == T_BOOL)
	    cprintf("(!%e^!%e)",e->e_l,e->e_r);
	else
	    cprintf("(%e^%e)",e->e_l,e->e_r);
	break;
    default:
	boom("bad operator in gen_logical");
	break;
    }
}



/* generate test for comparison operator */

static void
gen_test(e,tlab,flab,t_op,f_op)
Nodeptr e;
int tlab, flab;
char *t_op, *f_op;
{
    int sz;

    if (flab)  {
	assert(!tlab);
	gen_test(e,flab,0,f_op,t_op);
	return;
    }

    if (tlab)
	cprintf("if");
    sz = get_size(e->e_r);
    if (e->e_l->e_sig->s_type == T_CHAR && e->e_r->e_sig->s_type == T_CHAR
    && get_size(e->e_l) == 1 && sz == 1)
	cprintf("(%e%s%e)",e->e_l,t_op,e->e_r);
    else if (is_string(e->e_r->e_sig))
	cprintf("(sr_strcmp(%S,%S)%s0)",e->e_l,e->e_r,t_op);
    else if (assignable(e->e_l->e_sig))
	cprintf("(%e%s%e)",e->e_l,t_op,e->e_r);
    else if (e->e_r->e_sig->s_type == T_CAP)
	gen_cap_cmp(e->e_l,e->e_r,t_op,f_op);
    else 
	cprintf("(memcmp(%a,%a,%d)%s0)",e->e_l,e->e_r,sz,t_op);
    if (tlab)	
	cprintf("goto %g;\n",tlab);
}



/* generate capability comparison */

static void
gen_cap_cmp(l,r,t,f)
Nodeptr l, r;
char *t, *f;
{
    if (l->e_op == TK_RESCAP_NULL || l->e_op == TK_RESCAP_NOOP)
	gen_cap_cmp(r,l,t,f);
    else if (r->e_op == TK_RESCAP_NULL)
	cprintf("(((rescap*)%a)->seqn%s%d)",l,t,NULL_SEQN);
    else if (r->e_op == TK_RESCAP_NOOP)
	cprintf("(((rescap*)%a)->seqn%s%d)",l,t,NOOP_SEQN);
    else
	cprintf("(memcmp(%a,%a,%d)%s0)",l,r,get_size(r),t);
}
