/* bounds.c */

#include <stdio.h>

#include "sr.h"
#include "funcs.h"
#include "tokmacs.h"
#include "globals.h"


static Bool good_index();
static Nodeptr add1(), sub1(), castmaybe(), chk_divide();
static Symptr int_type();


struct a_bound {
    int a_size;			/* constant, SIZE_UNK, or SIZE_ARB */
    Nodeptr a_runtimesize;	/* expression if SIZE_UNK */
};        


/* fill in size and value of signature based on ranges */
/* if mangle, also need to doctor id's ranges,
	replacing TK_ARB's with appropriate expressions */
void
range_size(id, signature, mangle)
Symptr id, signature;
Bool mangle;
{   int size;
    Nodeptr anode, tval, tval2, value;
    Rangeptr rptr;
    int i, j;

    if (dbflags['Z']) {
	printf("range_size (id, signature, mangle=%d):\n",mangle);
	psym(id);
	psym(signature);
	printf("\n");
    }

    rptr = id->s_ranges;	/* assume make_node folds constants */

    if (!rptr) {
	signature->s_size = 1;
	return;
    }

    anode = rptr->r_dim1;
    assert(anode);
    assert(anode->e_op == TK_RANGE);
    if (is_constant(anode->e_l, &i) && is_constant(anode->e_r, &j))
    {   size = j - i + 1;
	if (size <= 0)
	    FATAL("size is not positive in range_size");
	if (anode = rptr->r_dim2)
	{   assert(anode->e_op == TK_RANGE);
	    if (is_constant(anode->e_l, &i) && is_constant(anode->e_r, &j))
	    {
		assert(size > 0);
		size *= j - i + 1;
	    }
	    else if (anode->e_r->e_op==TK_ARB || anode->e_l->e_op==TK_ARB)
	    {
		if (!mangle)
		{   size = SIZE_ARB;
		    value = NULLNODE;
		}
		else if (anode->e_r->e_op == TK_ARB)
		{   if (anode->e_l->e_op == TK_ARB
			|| (id->s_kind != K_PARAM && id->s_kind != K_RESULT))
			boom("TK_ARB unexpected");
		    value = snode(TK_RUNTIMESIZE, id, NULLNODE);
		    /* build expression for right hand bound */
		    release_node(anode->e_r);
		    tval = chk_divide(value,numnode(size));
		    tval = bnode(TK_PLUS, tval, copy_nodes(anode->e_l));
		    anode->e_r = sub1(tval);
		    size = SIZE_UNK;
		}
		else	/* (anode->e_l->e_op == TK_ARB) */
		{   if (id->s_kind != K_PARAM && id->s_kind != K_RESULT)
			    boom("TK_ARB unexpected");
		    value = snode(TK_RUNTIMESIZE, id, NULLNODE);
		    /* build expression for left hand bound */
		    release_node(anode->e_l);
		    tval = chk_divide(value,numnode(size));
		    tval2= castmaybe(copy_nodes(anode->e_r),int_type());
		    tval = bnode(TK_MINUS, tval2, tval);
		    anode->e_l = add1(tval);
		    size = SIZE_UNK;
		}
	    }
	    else
	    {
		value = copy_nodes(anode->e_r);
		value = castmaybe(bnode(TK_MINUS, value, 
		    copy_nodes(anode->e_l)), int_type());
		value = add1(value);
		value = bnode(TK_STAR, numnode(size), value);
		size = SIZE_UNK;
	    }
	}
    }
    else if (anode->e_r->e_op == TK_ARB || anode->e_l->e_op == TK_ARB)
    {			/* first dimension has arbitrary size */
	if (rptr->r_dim2 && (rptr->r_dim2->e_l->e_op == TK_ARB
		|| rptr->r_dim2->e_r->e_op == TK_ARB))
	    boom("you're trying my patience");
	if (!mangle) {
	    size = SIZE_ARB;
	    value = NULLNODE;
	} else if (anode->e_r->e_op == TK_ARB) {
	    if (anode->e_l->e_op == TK_ARB
		|| (id->s_kind != K_PARAM && id->s_kind != K_RESULT))
		boom("TK_ARB unexpected");
	    else
	    {   value = snode(TK_RUNTIMESIZE, id, NULLNODE);
		/* make expression for second bound of first dimension */
		if (rptr->r_dim2)
		{   tval = copy_nodes(rptr->r_dim2->e_r);
		    tval = castmaybe(bnode(TK_MINUS, tval, 
			copy_nodes(rptr->r_dim2->e_l)), 
			int_type());
		    tval2 = copy_nodes(value);
		    tval = chk_divide(tval2, tval);
		}
		else
		    tval = copy_nodes(value);
		tval = bnode(TK_PLUS, tval,
			castmaybe(copy_nodes(anode->e_l), int_type()));
		release_node(anode->e_r);
		anode->e_r = castmaybe(sub1(tval), anode->e_l->e_sig);
	    }
	    size = SIZE_UNK;
	}
	else		/* (anode->e_l->e_op == TK_ARB) */
	{   if (id->s_kind != K_PARAM && id->s_kind != K_RESULT)
		boom("TK_ARB unexpected");
	    value = snode(TK_RUNTIMESIZE, id, NULLNODE);
	    /* make expression for first bound of first dimension */
	    if (rptr->r_dim2)
	    {   tval = copy_nodes(rptr->r_dim2->e_r);
		tval = bnode(TK_MINUS, tval, 
		    castmaybe(copy_nodes(rptr->r_dim2->e_l),
			int_type()));
		tval2 = copy_nodes(value);
		tval = chk_divide(tval2, tval);
	    }
	    else
		tval = copy_nodes(value);
	    tval2 = copy_nodes(anode->e_r);
	    tval = bnode(TK_MINUS, tval2, tval);
	    anode->e_l = add1(tval); 
	    size = SIZE_UNK;
	}
    }
    else		/* no arbs in first dimension */
    {   int ii;

	value = copy_nodes(anode->e_r);
	value = castmaybe(bnode(TK_MINUS, value, 
	    copy_nodes(anode->e_l)), int_type());
	value = add1(value);
	if (!is_constant(value, &ii))
	    size = SIZE_UNK;
	    /* at this point, value evaluates to the size 
			    of first dimension */
	if (anode = rptr->r_dim2)
	{   assert(anode->e_op == TK_RANGE);
	    if (is_constant(anode->e_l, &ii) &&
		    is_constant(anode->e_r, &j))
	    {
		value = bnode(TK_STAR,numnode(j-ii+1),value);
	    }
	    else if (anode->e_r->e_op == TK_ARB ||
		anode->e_l->e_op == TK_ARB)
	    {   
		if (!mangle)
		{   release_node(value);
		    size = SIZE_ARB;
		    value = NULLNODE;
		}
		else
		{
		    tval = snode(TK_RUNTIMESIZE,id,NULLNODE);
		    value = chk_divide(tval, value);

		    if (anode->e_r->e_op == TK_ARB)
		    {
			if (anode->e_l->e_op == TK_ARB ||
			    (id->s_kind != K_PARAM && id->s_kind != K_RESULT))
			    boom("TK_ARB unexpected");
			tval = castmaybe(copy_nodes(anode->e_l),int_type());
			tval = bnode(TK_PLUS,tval,value);
			tval = sub1(tval);
			release_node(anode->e_r);
			anode->e_r = castmaybe(tval,anode->e_l->e_sig);
		    }
		    else	/* anode->e_l->e_op == TK_ARB */
		    {
			if (id->s_kind != K_PARAM && id->s_kind != K_RESULT)
			    boom("we're in sad shape boys");
			tval = castmaybe(copy_nodes(anode->e_r),int_type());
			tval = bnode(TK_MINUS, value, tval);
			tval = add1(tval);
			release_node(anode->e_l);
			anode->e_l = castmaybe(tval, anode->e_r->e_sig);
		    }
		    size = SIZE_UNK;
		    value = snode (TK_RUNTIMESIZE, id, NULLNODE);
		}
	    }
	    else	/* no arbs in second dimension */
	    {   tval = copy_nodes(anode->e_r);
		tval = castmaybe(bnode(TK_MINUS, tval, 
		    copy_nodes(anode->e_l)), int_type());
		tval = add1(tval);
		value = bnode(TK_STAR, tval, value);
		size = SIZE_UNK;
	    }
	}
    }
    signature->s_size = size;
    signature->s_value = value;
    signature->s_ranges = id->s_ranges;
}    


/* check_size(left,right) -- check sizes for compatibility */
Bool
check_size(left, right)
Nodeptr left, right;
{
    int lsize, rsize;
    Type ltype, rtype;

    if (dbflags['Z']) {
	printf("check_size(left,right):\n");
	pnode(left);
	pnode(right);
	printf("\n");
    }

    lsize = left->e_sig->s_size;
    rsize = right->e_sig->s_size;
    assert(rsize != SIZE_ARB);
    if (lsize == rsize)
	return TRUE;
    ltype = left->e_sig->s_type;
    rtype = right->e_sig->s_type;
    if (ltype == T_STRING && rtype == T_CHAR)
	return lsize == 1;
    if (rtype == T_STRING && ltype == T_CHAR)
	return rsize == 1;
    if (lsize == SIZE_ARB && rsize == SIZE_UNK && right->e_sig->s_value == 0)
	return FALSE;
    if (lsize == SIZE_ARB || lsize == SIZE_UNK || rsize == SIZE_UNK)
	return TRUE;
    return FALSE;
}

static Nodeptr
chk_divide(dividend, divisor)
Nodeptr dividend, divisor;
{
    int i, j;

    if (is_constant(dividend,&i) && is_constant(divisor,&j) && (j==0 || i%j)) {
	release_node(dividend);
	release_node(divisor);
	return NULLNODE;
    } else
	return bnode(TK_DIV, dividend, divisor);
}




/*  fix array subscripts:  change TK_ARB subscripts to TK_LB1 etc. */

void
fix_subs(s,subs)
Symptr s;
Nodeptr subs;
{
    Nodeptr r;

    /* process first or only dimension */
    r = subs->e_l;
    assert(r->e_op == TK_RANGE);
    if (r->e_l->e_op == TK_ARB) {
	r->e_l = snode(TK_LB1,s,NULLNODE);
	if (!r->e_r)
	    FATAL("'*' cannot stand alone in subscript");
    }
    if (r->e_r && (r->e_r->e_op == TK_ARB))
	r->e_r = snode(TK_UB1,s,NULLNODE);

    /*  process second dimension, if present  */
    if (!subs->e_r)
	return;
    r = subs->e_r->e_l;
    assert(r->e_op == TK_RANGE);
    if (r->e_l->e_op == TK_ARB) {
	r->e_l = snode(TK_LB2,s,NULLNODE);
	if (!r->e_r)
	    FATAL("'*' cannot stand alone in subscript");
    }
    if (r->e_r && (r->e_r->e_op == TK_ARB))
	r->e_r = snode(TK_UB2,s,NULLNODE);
}




/*  fix substring indices:  change TK_ARB subscripts to 1 or TK_LENGTH  */

void
fix_substr(id,subs)
Nodeptr id, subs;
{
    assert(!subs->e_r);
    subs = subs->e_l;
    assert(subs->e_op == TK_RANGE);
    if (subs->e_l->e_op == TK_ARB) {
	subs->e_l = numnode(1);
	if (!subs->e_r)
	    FATAL("'*' cannot stand alone in subscript");
    }
    if (subs->e_r && (subs->e_r->e_op == TK_ARB))
	subs->e_r = bnode(TK_LENGTH,id,NULLNODE);
}



/*  see if expression node is compatible with specified ranges specification
    fill in size of resulting signature
*/
Bool
check_bounds(signature, ranges, node)
Symptr signature;
Rangeptr ranges;
Nodeptr node;
{   int i, j, size;
    Nodeptr tval, value;
    struct a_bound top1, bottom1, top2, bottom2;
    int arb_range;		/* how many arbitrary sizes here? */

/* for all constants, i need to check that indexes agree with specified
	bounds, (size compatibility will be checked at a higher level)

   for non-constants, the size should come back unknown or arbitrary.
	for any of these thingies, mike should check the bounds at run
	time.

   it is not clear when mike will also need to check for size compatibility
	at run time.  he should not need to check, for example, when i have
	generated bound expressions to fill in a star, (if there is a problem,
	then bounds checking should be sufficient to catch the error).  

	but he does need to check for expressions like:
		a[1:i] := b[j:5]
			i.e. besides checking that i and j are correct
			bounds, he also needs to check that i-1 == 5-j

*/

    if (ranges == (Rangeptr) 0)
        return FALSE;

    if (node->e_op != TK_LIST || !node->e_l || !ranges->r_dim1)
        boom("improper expression tree in check_bounds()");

    if (!sigcmp(node->e_l->e_sig,
            ranges->r_dim1->e_sig, node->e_l, ranges->r_dim1, 0))
        return FALSE;

    arb_range = 0;
    if (!is_constant(ranges->r_dim1->e_l, &(bottom1.a_size)))
    {   assert(ranges->r_dim1->e_l->e_op != TK_ARB);
	bottom1.a_size = SIZE_UNK;
    }
    if (!is_constant(ranges->r_dim1->e_r, &(top1.a_size)))
    {   
	/* no similar assertion, would be false for string(*) */
	top1.a_size = SIZE_UNK;
    }
    if (ranges->r_dim2)
    {
	if (!is_constant(ranges->r_dim2->e_l, &(bottom2.a_size)))
	{   assert(ranges->r_dim2->e_l->e_op != TK_ARB);
	    bottom2.a_size = SIZE_UNK;
	}
	if (!is_constant(ranges->r_dim2->e_r, &(top2.a_size)))
	{   assert(ranges->r_dim2->e_r->e_op != TK_ARB);
	    top2.a_size = SIZE_UNK;
	}
    }

    if (good_index(bottom1, top1, node->e_l->e_l) == FALSE
	|| (node->e_l->e_r 
	    && (good_index(bottom1, top1, node->e_l->e_r) == FALSE)))
	return FALSE;
    else if (node->e_r)
    {   if (!ranges->r_dim2)
	    return FALSE;	/* attempt to index within 
					non-existent dimension */
 	if (sigcmp(ranges->r_dim2->e_sig,
	        node->e_r->e_sig, ranges->r_dim2, node->e_r, 0)
		== FALSE)
	    return FALSE;
	else if (good_index(bottom2, top2, node->e_r->e_l) == FALSE
	    || (node->e_r->e_r
		&& (good_index(bottom2, top2, node->e_r->e_r) == FALSE)))
	    return FALSE;
    }
    else if (ranges->r_dim2)
	return FALSE;		/* need to specify both indexes */

	/* all constant valued indexes are within constant bounded 
		ranges as specified by variable declaration
	*/

    if (node->e_l->e_l->e_op == TK_ARB)
    {   arb_range++;
	/* also need to check for stars standing by themselves,
		e.g. a[*,1:5]
	*/
	if (!node->e_l->e_r)
	    return FALSE;
    }
    if (node->e_l->e_r && node->e_l->e_r->e_op == TK_ARB)
	arb_range++;
    if (node->e_r
	&& node->e_r->e_l->e_l->e_op == TK_ARB)
    {   arb_range++;
	/* also need to check for stars standing by themselves,
		e.g. a[*,1:5]
	*/
	if (!node->e_r->e_l->e_r)
	    return FALSE;
    }
    if (node->e_r && node->e_r->e_l->e_r && node->e_r->e_l->e_r->e_op == TK_ARB)
	arb_range++;

    if (arb_range) { 
	signature->s_size = SIZE_UNK;
	return TRUE;
    }
    else if (node->e_l->e_r == NULLNODE)
        size = 1;
    else if (is_constant(node->e_l->e_l, &i) == FALSE
	|| is_constant(node->e_l->e_r, &j) == FALSE)
    {   
	value = copy_nodes(node->e_l->e_r);
	value = bnode(TK_MINUS, value, copy_nodes(node->e_l->e_l));
	value = add1(value);
        size = SIZE_UNK;
    }
    else
    {   size = j - i + 1;
        if (size < 0)
	    return FALSE;
    }
        
    if (node = node->e_r)
    {
	if (node->e_l->e_r == NULLNODE)
	    ;		/* size is determined by first dimension */
        else if (size == SIZE_UNK)
	{   tval = copy_nodes(node->e_l->e_r);
	    tval = bnode(TK_MINUS, tval, copy_nodes(node->e_l->e_l));
	    tval = add1(tval);
	    value = bnode(TK_STAR, value, tval);
	}
        else if (is_constant(node->e_l->e_l, &i) == FALSE
	    || is_constant(node->e_l->e_r, &j) == FALSE)
	{   tval = copy_nodes(node->e_l->e_r);
	    tval = bnode(TK_MINUS, tval, copy_nodes(node->e_l->e_l));
	    tval = add1(tval);
	    value = castmaybe(numnode(size), tval->e_sig);
	    value = bnode(TK_STAR, value, tval);
	    size = SIZE_UNK;
	}
        else
        {   j = j - i + 1;
	    if (j < 0)
		return FALSE;
	    size *= j;
	}
    }
    signature->s_size = size;
    signature->s_value = value;
    return TRUE;
}


/* fill in signatures of TK_ARB if necessary */
Bool
range_compatible(op, lbound, ubound)
Nodeptr op;
Symptr lbound, ubound;
{
    if (lbound == NULLSYM)			/* shouldn't happen */
        return FALSE;
    else if (ubound == NULLSYM)			/* scalar range */
        return TRUE;
    else if (lbound->s_type == T_STAR)  {	/* arbitrary size */
	if (ubound->s_type == T_STAR)
            op->e_l->e_sig = new_sig(T_INT);	/* hope so... */
        else if (!IS_ORDERED(ubound->s_type))
            return FALSE;
        else 
            op->e_l->e_sig = ubound;
    } else if (ubound->s_type == T_STAR) {
	if (!(IS_ORDERED(lbound->s_type)))
            return FALSE;
        else
            op->e_r->e_sig = lbound;
    }
    else if (ubound->s_type != lbound->s_type)
        return FALSE;
    else if (ubound->s_type == T_ENUM && ubound->s_tdef != lbound->s_tdef)
	return FALSE;
    /* following in not just "else" ... can fall from above also */
    return TRUE;
}



/* does the expression represented by value fall between bottom and top?
	if we can even tell at compile time
*/
static Bool
good_index(bottom, top, value)
struct a_bound top, bottom;
Nodeptr value;
{   int i;

    if (is_constant(value, &i))
    {
	if (bottom.a_size >= 0 && bottom.a_size > i)
	    return FALSE;
	else if (top.a_size >= 0 && top.a_size < i)
	    return FALSE;
    }
    return TRUE;	/* at least no compile-time conflict */
}



static Nodeptr
add1(a_node)
Nodeptr a_node;
{
    return bnode(TK_PLUS, a_node, castmaybe(numnode(1), a_node->e_sig));
}



static Nodeptr
sub1(a_node)
Nodeptr a_node;
{
    return bnode(TK_MINUS, a_node, castmaybe(numnode(1), a_node->e_sig));
}



static Nodeptr 
castmaybe(node, sig)
Nodeptr node;
Symptr sig;
{
    if (sig->s_type != node->e_sig->s_type) {   
	node = bnode(TK_LIST, node, NULLNODE);
	node = snode(TK_CAST, sig, node);
    }
    return node;
}



static Symptr
int_type()
{
    static Symptr int_sig = NULLSYM;

    if (int_sig == NULLSYM)
	    int_sig = new_sig(T_INT);
    return int_sig;
}
