/*  sparc.s -- assembly language code for the SPARC architecture  */


/* note: this code works, but was written by 2 neophyte sun4 assembly
 * language peons.  it could undoubtably be improved by someone more
 * experienced with the ins and outs (pun intended) of the sun4.
 */

#include <sun4/asm_linkage.h>
#include <sun4/trap.h>

#define MAGIC 618033989			/* any unlikely long integer */
#define RSIZE 0x3c			/* size of register save area */

	.seg	"data"
	.align	0x4			/* do we need this? */
	.global curr_stack
curr_stack:				/* saves addr of curr context (stack) */
	.word	dummy_stack
dummy_stack:				/* fake initial context */
	.skip	RSIZE			/* room for initial regs and args */
	.word	MAGIC			/* magic word to pass sanity check */

/*  sr_build_context(code,buf,bufsize,a1,a2,a3,a4) -- create a new context.
 *
 *  code	 entry point of the code to be executed in the context
 *  buf		 buffer for holding the context array
 *  bufsize	 size of the buffer
 *  a1 - a4	 four int-sized arguments to be passed to the code
 *
 *  note: we build an initial frame used just to jump to xxx
 *  to simplify handling underflow.
 *  the xxx routine just calls the routine specified by code argument
 *  to build_context with args a1-4;
 *	code and a1-4 are saved by build_context at the bottom of the context.
 */

	.seg	"text"
	.global	_sr_build_context
_sr_build_context:
	save	%sp,-SA(MINFRAME),%sp
	nop

	mov		%i1,%o1			/* %o1 points to context */
	add		%o1,%i2,%o1		/* Incr %o1 to end of context */
	dec		0x8,%o1			/* eliminate extra slop */
	and		%o1,~(STACK_ALIGN-1),%o1  /* Align down dirty */

	mov		%o1,%o2
	dec		SA(MINFRAME),%o1	/* build an initial frame */
	st		%o2,[%o1+0x38]		/* save fp (not really needed)*/
	mov		%o1,%o2
	dec		SA(MINFRAME),%o1	/* build an initial frame */
	set		xxx,%o3
	dec		0x8,%o3
	st		%o3,[%o1+0x3c]		/* save xxx in initial frame */
	st		%o2,[%o1+0x38]		/* save fp (not really needed)*/

	st		%g1,[%i1]		/* Save %g1 */
	st		%g2,[%i1+0x4]		/* Save %g2 */
	st		%g3,[%i1+0x8]		/* Save %g3 */
	st		%g4,[%i1+0xc]		/* Save %g4 */
	st		%g5,[%i1+0x10]		/* Save %g5 */
	st		%g6,[%i1+0x14]		/* Save %g6 */
	st		%g7,[%i1+0x18]		/* Save %g7 */
	mov		%y,%o3
	st		%o3,[%i1+0x1c]		/* Save %y */
	st		%o1,[%i1+0x20]		/* Save user stack pointer */
	st		%o2,[%i1+0x24]
	st		%i3,[%i1+0x28]		/* save arg 1 */
	st		%i4,[%i1+0x2c]		/* save arg 2 */
	st		%i5,[%i1+0x30]		/* save arg 3 */
	ld		[%fp+0x5c],%o3		/* save arg 4 */
	st		%o3,[%i1+0x34]
	st		%i0,[%i1+0x38]		/* save start of code address */

	set		MAGIC,%o3
	st		%o3,[%i1+0x3c]		/* Save magic word */

	ret
	restore

	.seg	"text"
	.global	_sr_chg_context
_sr_chg_context:
	save	%sp,-SA(MINFRAME),%sp
	ta		ST_FLUSH_WINDOWS

	set		curr_stack,%o0		/* Load addr of current stack */
	ld		[%o0],%o0
	st		%g1,[%o0]		/* Save %g1 */
	st		%g2,[%o0+0x4]		/* Save %g2 */
	st		%g3,[%o0+0x8]		/* Save %g3 */
	st		%g4,[%o0+0xc]		/* Save %g4 */
	st		%g5,[%o0+0x10]		/* Save %g5 */
	st		%g6,[%o0+0x14]		/* Save %g6 */
	st		%g7,[%o0+0x18]		/* Save %g7 */
	mov		%y,%o3
	st		%o3,[%o0+0x1c]		/* Save %y */
	st		%sp,[%o0+0x20]		/* Save user stack pointer */
	st		%fp,[%o0+0x24]		/* Save frame pointer */

	inc		RSIZE,%o0
	cmp		%o0,%sp			/* check that not overflowing */
	bgeu		over
	nop

	ld		[%o0],%o1		/* maybe catch earlier ovflow */
	set		MAGIC,%o2
	cmp		%o1,%o2
	bne		over
	nop

	ld		[%i0+RSIZE],%o1		/* this should be magic */
	set		MAGIC,%o2
	cmp		%o1,%o2			/* make sure new stk looks ok */
	bne		bad
	nop


	set		curr_stack,%o0		/* Load addr of current stack */
	st		%i0,[%o0]
	ld		[%o0],%o0

	ld		[%o0],%g1		/* Load %g1 */
	ld		[%o0+0x4],%g2		/* Load %g2 */
	ld		[%o0+0x8],%g3		/* Load %g3 */
	ld		[%o0+0xc],%g4		/* Load %g4 */
	ld		[%o0+0x10],%g5		/* Load %g5 */
	ld		[%o0+0x14],%g6		/* Load %g6 */
	ld		[%o0+0x18],%g7		/* Load %g7 */
	ld		[%o0+0x1c],%o1		/* Load %y */
	mov		%o1,%y
	ld		[%o0+0x20],%sp		/* Load user stack pointer */
	ld		[%o0+0x24],%fp		/* Load frame pointer */

	ld		[%sp],%l0		/*  ta ST_UNFLUSH_WINDOWS  */
	ld		[%sp+0x4],%l1
	ld		[%sp+0x8],%l2
	ld		[%sp+0xc],%l3
	ld		[%sp+0x10],%l4
	ld		[%sp+0x14],%l5
	ld		[%sp+0x18],%l6
	ld		[%sp+0x1c],%l7
	ld		[%sp+0x20],%i0
	ld		[%sp+0x24],%i1
	ld		[%sp+0x28],%i2
	ld		[%sp+0x2c],%i3
	ld		[%sp+0x30],%i4
	ld		[%sp+0x34],%i5
						/* fp was already restored */
	ld		[%sp+0x3c],%i7

	ret
	restore

	.seg	"text"
	/* this routine acts as a go between to the code specified
	 * to build_context.
	 * it just calls that code with args; if that ever returns,
	 * we have stack underflow.
	 */
xxx:
	save	%sp,-SA(MINFRAME),%sp
	nop
	set		curr_stack,%o4		/* grab code, a1-4 out of
						   bottom of context. */
	ld		[%o4],%o4
	inc		RSIZE-0x14,%o4		/* go to beginning of args. */
	ld		[%o4],%o0		/* set up args. */
	ld		[%o4+0x4],%o1
	ld		[%o4+0x8],%o2
	ld		[%o4+0xc],%o3
	ld		[%o4+0x10],%o4		/* set o4 to the code. */
	call	%o4				/* branch to code. */
	nop

	b		under			/* never returns! */
	nop

	.seg	"text"
	.global	_sr_check_stk
_sr_check_stk:
	save	%sp,-SA(MINFRAME),%sp
	set		curr_stack,%o0
	ld		[%o0],%o0
	inc		RSIZE,%o0
	cmp		%o0,%sp			/* check that not overflowing */
	bgeu		over
	nop

	ret
	restore

/*  stack problem handlers  (these calls do not return)  */

over:	call	_sr_stk_overflow
		nop
under:	call	_sr_stk_underflow
		nop
bad:	call	_sr_stk_corrupted
		nop
