/*
 *  SR Run-Time Support -- Nugget.  Semaphore Routines.
 */

#include "rts.h"

static sem sem_free;	/* semaphore free list */

sem
sr_make_sem (sr_init_val)
int sr_init_val;
{
    sem sp;

    if ((sp = sem_free) == NULL)
	sr_abort ("too many semaphores");

    sem_free = sp->next;
    sp->next = NULL;
    sp->value = sr_init_val;

    if (sp->blocked.head != NULL) {
	proc pr;
	/*
	 *	Clean up dead processes from last use of semaphore.
	 *	Can't do this from sr_kill_sem because it can be called
	 *	indirectly from destroy, which may have mutex for
	 *	resource descriptor, which rem_proc also needs.
	 *	Probably won't occur; experimental code.
	 */
	while ((pr = sp->blocked.head) != NULL)   {
	    sp->blocked.head = pr->next;
	    rts_warn ("killing proc blocked on killed sem");
	    sr_kill (pr, TRUE);
	    sp->blocked.tail = NULL;
	}
    }

    DEBUG (0x4000, "r%06X p%06X new_sem  s%06X", sr_cur_res, sr_cur_proc, sp);
    return (sp);
}



/*
 *  Kill a semaphore.
 */
void
sr_kill_sem (sp)
sem sp;
{

    if (sp->blocked.head)
	rts_warn ("processes blocked on killed sem");

    sp->next = sem_free;
    sem_free = sp;
    DEBUG (0x8000, "r%06X p%06X sr_kill_sem s%06X",sr_cur_res,sr_cur_proc,sp);
}



void
V (sp)						/* RTS Primitive */
sem sp;
{
    
    /* because V is used frequently within the RTS, don't check SP */

    DEBUG (0x1000, "r%06X p%06X V        s%06X", sr_cur_res, sr_cur_proc, sp);
    if (! sp->blocked.head)
	sp->value++;
    else
	awaken (sp->blocked);
}



void
P (sp)						/* RTS Primitive */
sem sp;
{
    
    /* because P is used frequently within the RTS, don't check SP */

    DEBUG (0x2000, "r%06X p%06X P        s%06X", sr_cur_res, sr_cur_proc, sp);
    if (sp->value)
	sp->value--;
    else {
	block (& sp->blocked);
	sr_cswitch();
    }
}



/*
 *  Initialize the free list of semaphores.
 */
void
sr_init_sem ()
{
    int i;
    sem sp;

    /*
     *	Initialize semaphore and process descriptor free lists.
     */
    sp = (sem) sr_alloc (sr_max_semaphores * sizeof (struct sem_st));
    for (i = 0 ; i <= sr_max_semaphores-1 ; i++) {
	(sp + i)->next = sp + i + 1;
	(sp + i)->blocked.head = NULL;
	(sp + i)->blocked.tail = NULL;
    }

    (sp + sr_max_semaphores - 1)->next = NULL;
    sem_free = sp;
}
