/*
 *  SR Run-Time Support.  Data Structures for Resource Support.
 */

#define INIT_REPLY  0x01  /* initial process has replied */
#define FINAL_REPLY 0x02  /* final process has replied */
#define FREE_SLOT   0x04  /* this slot is currently free */



/* remote create reply message */

struct crep_st {
    struct pach_st ph;	/* packet header */
    status stat;	/* remote create outcome status */
    rescap rcap;	/* resource capability */	
};



/* remote destroy request message */

struct dest_st {
    struct pach_st ph;	/* packet header */
    rescap rc;		/* resource capability */
};



/* resource instance descriptor */

struct rint_st {
    tindex rpatid;	/* resource pattern */
    seq seqn;		/* sequence number */
    daddr rv_base;	/* base addr of res variable area */
    crb crb_addr;	/* address of create request block */
    sem mutex;		/* mutual exclusion for descriptor */
    proc procs;		/* processes belonging to resource */
    memh meml;		/* list of memory allocated to res */
    rescap *rcp;	/* addr of res cap during create */
    short rc_size;	/* size of res cap in bytes */
    short noper;	/* number of proc operations */
    oper oper_list;	/* list of proc operations */
    int status;		/* initial/final/reply status flag */
    rint next;		/* free list link */
};



/* resource pattern table entry */

struct rpat_st {
    paddr init;		/* initialization code */
    paddr final;	/* finalization code */
};



/* memory allocation list entry */

struct memh_st {
    rint res;		/* resource that owns memory block */
    memh mnext;		/* forward ptr in global mem list */
    memh mlast;		/* backward ptr in global mem list */
    memh rnext;		/* forward ptr in resource mem list */
    memh rlast;		/* backward ptr in resource mem list */
};
