/*
 *  SR Run-Time Support.  Data Structures for Processes and Semaphores.
 */

#define ACTIVE	0	/* order of these status codes is important */
#define READY	1
#define BLOCKED 2
#define INFANT	3
#define FREE	4




/*    process queues    */

struct proc_queue_st {
    proc head;		/* pointer to head of process list */
    proc tail;		/* pointer to tail of process list */
};

typedef struct proc_queue_st proc_queue;	/* process queues  */




/*  process descriptor  */

struct proc_st {
    daddr stack;	/* process context and stack */
    int status;		/* process status */
    enum pr_type ptype;	/* type of process */
    enum in_type itype;	/* type of invocation if a PROC */
    rint res;		/* resource process belongs to */

    proc_queue *blocked_on;	/* pointer to list process is blocked on */
    sem wait;		/* sem for initial completion */
    invb ibp;		/* addr of invocation block */
    cob cob_list;	/* list of co stmt blocks */
    class clap;		/* operation class for current input stmt */
    invb next_inv;	/* next pending invocation to examine */
    Bool else_leg;	/* in in statement with else leg */
    proc procs;		/* list of processes for resource */
    proc next;		/* ready, blocked, or free list */
    proc next_else;	/* next process with else option */
    };



/*  semaphore descriptor  */

struct sem_st {
    sem next;
    int value;
    proc_queue blocked;
    };



/*  Block the current process and place it on the  specified waiting list.  */

#define block(plist) { \
    sr_cur_proc->status = BLOCKED; \
    sr_cur_proc->blocked_on = (plist); \
    sr_enqueue ((plist), sr_cur_proc); \
    sr_num_blocked++; \
    DEBUG (0x200,"r%06X *%06X block    p%06X",sr_cur_res,*plist,sr_cur_proc); \
}



/*  Awaken the next process on the specified list.  */

#define awaken(plist) { \
    proc pr; \
    pr = (plist).head; \
    (plist).head = pr->next; \
    if (pr->next == NULL) { (plist).tail = NULL;}\
    pr->status = READY; \
    sr_enqueue (& sr_ready_list, pr); \
    sr_num_blocked--; \
    DEBUG (0x100, "r%06X p%06X awaken   p%06X", sr_cur_res, sr_cur_proc, pr); \
}
