/*
 *  SR Run-Time Support.  Data Structures for Operation Routines.
 */



/*  operation table entry  */

struct oper_st {
    rint res;		/* resource operation belongs to */
    seq seqn;		/* operation sequence number */
    short pending;	/* num pending input invocations for ? op */
    enum op_type type;	/* operation type */
    union {
	paddr code;	/* addr of code for operation */
	class clap;	/* input operation class */
	sem sema;	/* optimization for semaphore operations */
    } u;
    oper next;		/* list of operations for resource */
};



/*  co statement descriptor block  */

struct cob_st {
    seq seqn;		/* co sequence number */
    short pending;	/* num of pending invocations */
    sem mutex;		/* co block mutual exclusion */
    sem done;		/* for sr_co_wait to block on */
    invb done_list;	/* list of completed invocations */
    cob next;		/* list of co for process */
};



/* invocation queue structure */

struct inv_queue_st {
    invb head;		/* head of invocation list */
    invb tail;		/* tail of invocation list */
};

typedef struct inv_queue_st inv_queue;



/* operation class structure */

struct class_st {
    bool inuse;		/* exclusion lock */
    short pending;	/* num of pending invocations */
    short numops;	/* num of operations in this class */
    inv_queue old_in;	/* list of available invocations */
    inv_queue new_in;	/* arrivals while inuse == TRUE */
    proc_queue old_pr;	/* processes waiting for invocations */
    proc_queue new_pr;	/* processes eligible to gain access */
    proc else_pr;	/* first process with else option eligible to gain 
				access */
    proc else_tailpr;	/* last process with else option eligible to gain 
				access */
    class next;		/* free list link */
};
