/*
 *  SR Run-Time Support.  Macro Definitions.
 */


/*  Insert a node at the head of a single-headed doubly-linked list.  */

#define	insert(node,head,next,last) { \
    node->next = head; \
    node->last = NULL; \
    if (head != NULL) \
	head->last = node; \
    head = node; \
}



/*  Remove a node from a single-headed doubly-linked list.  */

#define	delete(node,head,next,last) { \
    if (node->last == NULL) { \
	if ((head = node->next) != NULL) \
	    head->last = NULL; \
    } else if ((node->last->next = node->next) != NULL) \
	node->next->last = node->last; \
    else node->last->next = NULL; \
}



/*  Print values v with format f if any debugging flags masked by n are set.  */

extern long sr_dbg_flags;
#ifndef NDEBUG
#define DEBUG(n,f,v1,v2,v3) ((sr_dbg_flags&(n))?sr_bugout(f,v1,v2,v3):0)
#else /*NDEBUG*/
#define DEBUG(n,f,v1,v2,v3)
#endif /*NDEBUG*/
