/*
 *  Common Debugging Routines for SR Execution Manager & Run-time Support.
 */

#include "rts.h"


static char xci[] = 		/* maps hex characters into integer values */
    "\0\12\13\14\15\16\17\0\0\0\0\0\0\0\0\0\0\1\2\3\4\5\6\7\10\11";

long sr_dbg_flags = 0;		/* currently enabled debugging options */



/*  sr_init_debug(s) - set debug flags according to hex string s  */

void
sr_init_debug(s)
char *s;
{
    if (!s)				/* if s is null, try env SRXDEBUG */
    	s = getenv("SRXDEBUG");
    if (!s)				/* if still nothing, return */
	return;
    while (*s)
        sr_dbg_flags = (sr_dbg_flags << 4) | xci[*s++ & 037];
}



/*  sr_bugout(f,v1,v2,v3) - print debugging output value v under format f  */
/*  (called by the DEBUG macro) */

int
sr_bugout(f,v1,v2,v3)
char *f;
int v1, v2, v3;		/* not always int, but this code is noncrucial so... */
{
    static char fmt[100];

    /* combine formats (vs. multiple writes) to ensure contiguous output */
    sprintf(fmt,"[%%d] %s\n",f);
    fprintf(stderr,fmt,sr_my_vm,v1,v2,v3);
    return (0);
}
