/*  csloop.c -- context switch loop
 *
 *  This program performs n context switches, to allow timing.
 *
 *  Usage:  csloop [n]		(default n is 1,000,000)
 */

#include <stdio.h>

#define N_SWITCH 1000000
#define STACK_SIZE 2000

char stk1[STACK_SIZE];
char stk2[STACK_SIZE];
char stk3[STACK_SIZE];
char stk4[STACK_SIZE];

int swdone = 0;
int swlimit = N_SWITCH;


/*  main program -- set up four contexts and execute in turn  */

main(argc,argv)
int argc;
char *argv[];
{
    int con();

    if (argc > 1)
	swlimit = atoi(argv[1]);
    sr_build_context(con,stk1,STACK_SIZE,stk2,0,0,0);
    sr_build_context(con,stk2,STACK_SIZE,stk3,0,0,0);
    sr_build_context(con,stk3,STACK_SIZE,stk4,0,0,0);
    sr_build_context(con,stk4,STACK_SIZE,stk1,0,0,0);

    sr_chg_context(stk1);
    /*NOTREACHED*/
}


/* this same function is executed in all four contexts */

con(next)
char *next;
{
    while (++swdone < swlimit)
	sr_chg_context(next);
    fprintf(stderr,"%d context switches performed\n",swdone);
    exit(0);
}


/*  error handling  */

sr_stk_overflow()  {fprintf(stderr,"stack overflow\n");  exit(1);}
sr_stk_underflow() {fprintf(stderr,"stack underflow\n"); exit(1);}
sr_stk_corrupted() {fprintf(stderr,"stack corrupted\n"); exit(1);}
