.\"  format with troff or nroff using the -ms macro package
.ds LF \\s7SR\-RELEASE\\s0	\" document label for the ordering system
.\"
.\" use Courier for SR text if it looks like psroff; otherwise use bold.
.\"
.ie 1i=576u .ds C \\fC
.el .ds C \\fB
.de SR          \" display SR code (first argument) in special font
\\&\\*C\\$1\\fP\\$2
..            
.de SS		\" subsection header
.PP
\\fB\\$1.\\fP
..
.\"
.TL
Release Notes for SR Version 1.1
.AU
Gregg Townsend
.AI
Department of Computer Science
The University of Arizona
.sp 1
July 24, 1989
.PP
This document surveys the changes introduced between Version 1.0
and Version 1.1 of the SR Programming Language.
The revised language is described more precisely in the reference manual.
.SH
New Platforms
.PP
SR now supports a wider variety of system architectures.
New systems include
the Decstation 3100,
the Sun 4,
the NeXT computer system,
and the Hewlett-Packard 9000 (series 300 and 800).
SR can now also run on Vax Ultrix systems if the GNU C compiler is available.
As a result of  the modifications these systems required,
additional ports should be considerably easier.
.SH
Incompatible Language Changes
.SS Signatures
Scalars are no longer considered compatible with arrays,
even if the size is the same.
For example, an integer vector of length 1 is no longer interchangeable
with a simple integer.
The new restriction is partially enforced at this time
and we anticipate stricter checking in the future.
.SS "Character Literals"
Single quotes now designate a character literal
instead of a string literal.
Double quotes still define a string literal.
A character literal has type
.SR char
and contains only one character.
For example,
.SR "\'x\'"
and
.SR "\'\en\'"
are character literals, 
while
.SR """x\en"""
is still a string literal.
.PP
String literals
.I must
be replaced by character literals in certain situations.
A string can no longer be assigned to a simple char variable
nor passed as an argument to the
.SR char()
conversion function, so
.br
.nf
.SR "	var c    : char := ""X"""
.SR "	var z[3] : char := ([3] char(""z""))"
become
.SR "	var c    : char := \'X\'"
.SR "	var z[3] : char := ([3] \'z\')"
.fi
.SH
Language Extensions
.SS "Operation Declarations"
For consistency with other declarations,
the syntax for operation declarations has been extended.
The forms
.SR "op a, b, c: optypename"
and
.SR "op x(...), y(...), z(...)"
are now accepted.
.SS "Semaphores"
A new
.SR sem
keyword allows explicit declaration of semaphores.
New
.SR P(name)
and
.SR V(name)
builtins are also provided.
These abbreviations provide no new facilities but
sometimes allow a clearer expression of the programmer's intentions.
Diagnostics are still in terms of the underlying implementation
as special operations.
.SS "Processes"
SR now allows the specification of quantifiers when declaring processes,
for example
.SR "process p (i:=1 to 3)"
declares an array of processes.
.SS "Co Statements"
A
.SR send
statement is now allowed as the invocation part of a
.SR co
statement.
.SS "Input Statements"
An
.SR else
clause is now allowed,
and will be executed if no invocation is selectable.
.SR st
is now allowed as an alternative to
.SR and
for introducing a synchronization expression.
.SS Pointers
Pointer arithmetic, similar to that of C, has been added.
Pointers can now be printed using
.SR write
and
.SR writes .
A generic pointer type
.SR "ptr any"
has been added.
.SS "New Timing Functions"
.SR "age()"
returns the elapsed time since creation of the current virtual machine.
.SR "nap(msec)"
suspends the current SR process for a specified interval.
.SH
Commands and Tools
.PP
.B srl
now accepts
.B .a
files as command arguments to allow linking with user libraries of C functions.
.PP
.B srl
no longer creates a
.B re-srl
file.
The
.B re-srl
file caused more confusion than it was worth.
.PP
.B srm
has a new
.B \-s
option to produce a smarter
.I Makefile.
.PP
.B srgrind
is a new script that uses
.I vgrind
to format SR code for
.I troff.
.PP
An SR editing mode for GNU Emacs is now provided.
.SH
Internal Improvements
.PP
Numerous bugs, notably some involving virtual machines, have been fixed.
.PP
I/O waiting is handled much more intelligently,
and periodic timer interrupts are no longer used.
Among other things,
these changes improve the performance of multiple-virtual-machine programs.
.PP
Code has been added to prevent a process
in a CPU loop from shutting out all others.
.PP
Smarter code generation has improved the performance of
.SR in
statements.
.SH
Documentation and Examples
.PP
The updated reference manual,
.I "Report on the SR Programming Language, Version 1.1,"
is included.
The installation guide and other documents were also revised.
The porting guide was completely rewritten.
.PP
PostScript versions of the documentation are now included in the distribution.
.PP
Some new programs have been added in the
.B examples
subdirectory.
One of these is a working version of the ``Dining Philosophers''
program from the SR Overview.
.SH
Acknowledgements
.PP
Many of these changes are due the efforts of outside contributors.
In particular, we thank
Ron Olsson, Carole McNamee, John Wagner, and Greg Whitehead
at the University of California at Davis;
and
David Jacobson, Ulrike Glavitsch, Luigi Semenzato, and Joe Park
at Hewlett-Packard.
