.\"  format with troff or nroff using the -ms macro package
.ds LF \\s7SR\-INSTALL\\s0	\" document label for the ordering system
.if t .nr PO 1.25i
.TL
Installing the SR Programming Language
.AU
Gregg Townsend
.AI
Department of Computer Science
The University of Arizona
.sp 1
July 21, 1989
.de CD
.nf
.in 10n
\\fB\\$1\\fR
.in
.fi
..
.SH
General Notes
.PP
The SR Programming Language is targeted at these systems:
.DS
Vax running BSD Unix\"(extended PDP-11 architecture)\"now,now...
Vax running Ultrix, using the \fBgcc\fP compiler
Decstation 3100 running Ultrix   (MIPS RISC architecture)
Encore Multimax running Umax  (National 32000 architecture)
Sun 4 running SunOS  (SPARC architecture)
Sun 2 or Sun 3 running SunOS  (Motorola 68000 architecture)
NeXT computer system running Mach  (Motorola 68000 architecture)
Hewlett-Packard 9000 series 300 running HP-UX  (Motorola 68000 architecture)
Hewlett-Packard 9000 series 800 running HP-UX  (Precision architecture)
.DE
The correct variant is selected automatically by checking predefined
preprocessor macros.
Specific system details are given in the Systems file in the main directory.
.PP
The standard distribution package requires about two megabytes of disk space.
This expands to around five megabytes during the build process.
The final, installed files occupy less than a megabyte.
.PP
The SR system is in the public domain and you may use and distribute it as you
wish.  We ask that you retain credits referencing the University of Arizona and
that you identify any changes you make.
.PP
We can't provide a warranty with SR; it's up to you to determine its suitability
and reliability for your needs.  We do intend to continue to develop and
maintain SR as resources permit, and would like to hear of any problems.
.SH
Unpacking the \fItar\fP file
.PP
If you haven't done so already, create a new directory for building the
SR system.
This directory can be located anywhere and can be removed completely
after the system has been built and installed.
.PP
The new directory will be called the ``main directory''
in these instructions,
and will be assumed to be your current directory for all commands illustrated.
.PP
Make the main directory your current directory, and type
.CD "tar xf \fIfile\fP"
where
.I file
is the disk or tape file of the SR distribution.
This will create several files and subdirectories.
.SH
System Components
.PP
The SR system consists of several components.
.B sr
and
.B srl
are the key programs used directly by an SR programmer.
The SR runtime system is loaded implicitly by \fBsrl\fP.
Supplemental tools, example programs, and documentation are also provided.
.PP
.B sr
is the compiler proper.
It translates an SR program into a C program,
then calls the C compiler to produce object code.
.PP
.B srl
is the SR linker.
It generates tiny C files of configuration information,
and invokes the C compiler to combine these with object
files and the runtime library.
The end product is an executable program.
.PP
.B srx
is an executive program that supervises multiple-machine programs.
It is not called explicitly but is
forked automatically by the runtime system.
.PP
.B srm
assists in the construction of complex programs by
inspecting SR source code and automatically
creating a correct
.I make
description file.
.PP
.B srtex
formats an SR program for typesetting by TeX.
.B srgrind
does a similar job for use with troff.
.B srgrind
requires Berkeley's
.I vgrind
program in order to function.
.PP
.B srv
runs verification tests to check that the SR system is functioning correctly.
.B srvi
installs new verification tests.
These programs are part of the installation process and are not used
by SR programmers.
.SH
Directory Structure
.LP
Important files in the main directory include:
.IP
.RS
.IP \fBREADME\fP 12n
General release information and last minute notes.  READ THIS FILE!
.IP \fBSystems\fP 12n
Detailed system-specific information.  READ THIS, TOO.
.IP \fBMakefile\fP 12n
The master file of
.I make
directives for building SR.
This file is edited to configure the system.
.IP \fBBugs\fP 12n
A list of currently known problems.
.IP \fBsr-mode.el\fP 12n
Lisp code implementing an SR editing mode for GNU Emacs.
.RE
.LP
There are also several source code files and other files used in the
build process.
.LP
Subdirectories of the main directory are:
.IP
.RS
.IP \fBsr\fP 12n
Source code for \fBsr\fP, the SR compiler.
.sp -.3
.IP \fBsrl\fP 12n
Source code for \fBsrl\fP, the SR linker.
.sp -.3
.IP \fBrts\fP 12n
Source code for the SR runtime system, including \fBsrx\fP.
.sp -.3
.IP \fBsrm\fP 12n
Source code for \fBsrm\fP, the Makefile builder.
.sp -.3
.IP \fBsrgrind\fP 12n
Source code for \fBsrgrind\fP, the troff formatter.
.sp -.3
.IP \fBsrtex\fP 12n
Source code for \fBsrtex\fP, the TeX formatter.
.sp -.3
.IP \fBsrv\fP 12n
Source code for \fBsrv\fP and \fBsrvi\fP, the verification tools.
.IP \fBvsuite\fP 12n
A suite of verification programs used by \fBsrv\fP.
.IP \fBexamples\fP 12n
A set of example programs; actually a symbolic link to \fBvsuite/examples\fP.
Each subdirectory of \fBexamples\fP contains a single SR program
in one or more \fB.sr\fP files,
plus other files used in the verification process.
.IP "" 12n
\fBexamples/dining\fP contains an updated, working version of the Dining
Philosophers program from the SR Overview (below).
.IP \fBman\fP 12n
Individual
.I man
pages for the various programs in the SR system.
Additionally,
.B man/manpages.ps
contains the entire set in PostScript form
for printing on a LaserWriter or similar device.
.IP \fBdoc\fP 12n
A collection of external and internal documentation files.
The most important documents are distributed both as
.I troff
source files and in PostScript form.
.RS
.IP \fBrelease.ms\fP 12n
Version 1.1 release notes, in
.I troff
form;
format using
.I "troff \-ms."
.sp -.3
.IP \fBrelease.ps\fP
The same release notes, in PostScript form.
.IP \fBinstall.ms\fP 12n
This installation guide, in
.I troff
form;
format using
.I "troff \-ms."
.sp -.3
.IP \fBinstall.ps\fP
This installation guide, in PostScript form.
.IP \fBport.ms\fP
Instructions for porting SR to a new system architecture, in
.I troff
form;
format using
.I "troff \-ms."
.sp -.3
.IP \fBport.ps\fP
The porting guide, in PostScript form.
.IP \fBreport\fP
Subdirectory containing the
.I "Report on the SR Programming Language, Version 1.1."
This is the SR reference manual;
.B report.ps
contains a preformatted PostScript copy.
The
.I Makefile
contains directives for rebuilding
.B report.ps
using
.I psroff,
and can be adapted to other formatters if needed.
.IP \fBoverview\fP
Subdirectory containing
.I "An Overview of the SR Language and Implementation."
This paper, from the January, 1988, issue of TOPLAS,
provides an introduction to SR.
It has not been updated, and does not correspond
exactly to the present SR language.
.B overview.ps
contains a PostScript copy,
and again the
.I Makefile
contains formatting directives.
.IP \fBQuestions\fP
A text file containing some assorted questions and answers
about SR.
.RE
.LP
The
.B internals
subdirectory contains some miscellaneous notes about the SR
implementation,
not necessarily current.
These are text files, not
.I troff
files.
.RE
.SH
Configuring the SR System
.PP
Before you even build SR you must decide where to install it.
Pathnames are embedded in the binaries so that (for example)
.I sr
can call
.I srl
and
.I srl
can find the runtime library.
Four directories must be specified: one for the commands,
one for hidden files such as the runtime library,
and two for the
.I man
pages.
.PP
If you plan to install SR as a local utility you might choose
distinct directories such as
.B /usr/local/bin,
.B /usr/local/lib/sr,
and then
.B /usr/man/manl
for all the
.I man
pages.
Alternatively, everything can be collected in a single directory
such as
.B /usr/sr/bin
or
.B /usr/yourname/bin.
Do not use any
.I existing
directories within the SR distribution,
but you can safely create a new
.B bin
subdirectory.
.PP
If the directories you have chosen do not now exist,
you must create them manually.
The installation process will not create new directories.
.PP
To configure the system, edit
.B Makefile
in the main directory.
Change the SRC definition to reflect the path of the main directory.
Define installation directories as described above for CMD, LIB, MAN1, and MAN5.
All directories must be absolute paths (beginning with `/'),
and no comments may appear on the definition lines.
.PP
If the
.I vgrind
program is available on your system, set VFPATH and VGMACS to the absolute
paths of its back end program and macro package.
Typical paths for Berkeley-derived systems are
/usr/lib/vfontedpr and /usr/lib/tmac/tmac.vgrind
respectively.
If
.I vgrind
is not available, set these definitions empty.
Note: without
.I vgrind,
.I srgrind
will not function.
.PP
If you run GNU Emacs, you may wish to install \fBsr-mode.el\fP,
which implements an SR editing mode.
To do this, set ELISP to the name of the directory containing
the Emacs Lisp functions (e.g. /usr/local/lib/gnuemacs/lisp).
.PP
A few other values can also be configured in the Makefile.
MANEXT defines the file extension for installed
.I man
pages.
VMASK defines a \fIumask\fP(2) to be used during verification runs.
The \fIxx\fPPATH definitions define the location of the C compiler
and other utilities called from within SR commands,
but do
.I not
affect the building of SR.
The CFLAGS definition sets compilation options for use while building SR.
.PP
Some system-specific warnings and configuration requirements
are given in the \fBSystems\fP file in the main directory.
.SH
Building and Testing
.PP
To build the SR system, simply type
.CD "make"
in the main directory.
This will build all the components of the SR system
within the SR directory structure;
nothing will be altered outside the structure.
The build will probably take 5 to 30 minutes
depending on system type and load.
.PP
If you later need to change the configuration information,
do so and again type \fBmake\fP.
The rebuild will go relatively quickly compared to a full build.
.PP
To check that the system is functional, type
.CD "srv/srv \-v quick"
to run the ``quick'' set of SR tests.
This will list the recently-built SR components and will then
list each test name as it is run.
.B \-v
causes each verification directive to be echoed.
.PP
If \fBvgrind\fP is absent,
the message ``expected 0, got 1 from srgrind'' will appear,
indicating that
.B srgrind
is unusable.
Any other error message indicates a problem.
.SH
Installing the System
.PP
After the system has been built and verified,
it must be installed in its ultimate destination as configured above.
Type
.CD "make install"
to copy the commands,
.I man
pages, and support files.
.PP
To verify a correct installation, type
.CD "srv/srv \-v \-p quick"
which will run the same tests as before, but using the installed files.
.SH
Configuring Virtual Machines
.PP
At this point,
a complete SR system has been built and installed.
Without further reconfiguration, however,
remote virtual machines may not work properly.
This reconfiguration was deferred
because it's much easier to test
using an installed, working system.
If you don't have a network of machines
or don't need to use
.B "create vm() on n"
you can skip this section.
.PP
When a program creates a virtual machine
and specifies a host machine on which to place it,
SR uses a remote shell to run the program on the remote host.
The remote shell program is
.I rsh (1)
on most systems and
.I remsh (1)
on HP-UX.
This is controlled by the RSHPATH
definition in the main Makefile.
.PP
The name of the executable file passed to
.I rsh
is the same for all remote hosts and is controlled
by an
.B srmap
file.
This contains patterns for matching the program's filename
and corresponding templates for generating the remote filename for
.I rsh.
The format of
.B srmap
is described in its \fIman\fP page,
\fBman/srmap.5\fP.
.PP
If your network provides transparent access to remote disks,
it should be possible to make remote execution work automatically
by specifying templates that generate host-independent filenames.
.B srmap.az
is an example of how this is done at Arizona.
.PP
Without remote disk access,
users of multiple virtual machines will need to manually
copy their programs to the remote hosts before beginning execution.
The configuration in
.B srmap
will control where the programs must be placed,
so a simple and straightforward method is desirable.
One way to do this is to generate a path relative to the
user's home directory.
For example, if \fBsrmap\fP contains the line
.CD "sequoia:/usr?/*/**     ~$2/$3"
then when a program
.B /usr3/uname/path
is run on host \fBsequoia\fP,
SR will expect to find copies of the executable in
.B ~uname/path
on remote machines.
.PP
Edit
.B srmap
in the main directory
and set up a configuration appropriate to your local situation.
Refer to the
.B srmap
.I man
page for a detailed description of the format,
and use the Arizona configuration as a starting point and an example.
.PP
Make sure that your search path includes the directory where you
just installed \fBsr\fP.
Go into the
.B examples/remote
subdirectory and type
.CD "sr remote.sr"
to compile a test program.
Set the environment variable SRMAP
to the
.I absolute
pathname of the new
.B srmap
file.
.PP
Begin with a simple test by typing
.CD a.out
to run the program with no arguments.
It should simply tell you the local hostname;
this verifies that
.B srx
is accessible,
and that the location of
.B a.out
matches one of the patterns in \fBsrmap\fP.
Then try giving the hostname as an explicit argument;
this will verify that the generated filename works on the present host.
.PP
Now add other hostnames as command arguments;
if remote execution fails (perhaps as expected),
then the diagnostics from
.I rsh
will give the file name attempted.
Copy
.B a.out
into other directories,
and onto other hosts if necessary.
Run it from various locations with various hostname arguments.
Run it using absolute and relative paths.
Try to test any special cases used in the
.B srmap
file.
.PP
When you are satisfied with the configuration in \fBsrmap\fP,
return to the main directory and type
.CD "make i-map"
to install it.
.SH
Cleaning Up
.PP
After the system has been installed, nothing within the SR directory structure
is needed to build or run SR programs.
The structure can be backed up on tape and removed from the disk.
.PP
If you wish to keep the source code online, type
.CD "make clean"
to remove intermediate files from the build process.
Typing
.CD "make cleanx"
will remove intermediate files and will also remove the executables
within the structure,
leaving it very close to its original state.
.PP
.I Note:
The cleanup process is a bit aggressive, and will remove all files
within the directory structure that satisfy certain tests.
If you have created files of your own within the structure, and you
wish to preserve them, it would be prudent to first copy them elsewhere.
.SH
The Full Verification Suite
.PP
The standard distribution of SR includes a few confidence tests
and sample programs in the main
.I tar
file.
These are the tests run by \fBsrv/srv quick\fP,
and should be sufficient to verify correct installation of
an unmodified SR system.
.PP
A more extensive set of tests is available for those who wish
to modify the compiler or transport it to a different system
architecture.
There are about 360 tests in 1800 files,
requiring about two megabytes of disk space.
.PP
The full test set is provided as a second
.I tar
file on tape distributions,
or as a separate file for
.I ftp
distributions.
This
.I tar
file, when unpacked in the main directory,
creates several new subdirectories of \fBvsuite\fP.
If
.B srv/srv
is run with no parameters it will execute all of the tests.
A full run may take a few hours.
.SH
Porting to Other Systems
.PP
It is possible to port SR to other system architectures
besides those presently supported;
some assembly language programming is required.
32-bit systems with conventional memory models,
running Berkeley-based Unix,
are most easily accommodated.
Instructions for porting SR are contained in
\fBdoc/port.ms\fP.
.SH
Feedback
.PP
Please let us know of any problems you encounter
so that we can continue to improve SR.
Our mailing address is:
.DS
SR Project
Department of Computer Science
Gould-Simpson Building
University of Arizona
Tucson, Arizona  85721
.DE
We can be reached by electronic mail at:
.DS
sr-project@Arizona.EDU
uunet!arizona!sr-project
.DE
We'll need to know what computer and operating system you are using,
what version of SR,
and your name, address, and telephone number.
.PP
Because of limited resources we can't promise to fix every problem,
but we appreciate all comments and will acknowledge all mail.
.SH
Acknowledgement
.PP
Ron Olsson helped debug the installation process
and provided several suggestions for making it easier.
.SH
References
.LP
Gregory R. Andrews, Ronald A. Olsson, et al.,
.I "An Overview of the SR Language and Implementation."
ACM Trans. on Prog. Lang. and Systems 10, 1 (January, 1988), 51-86.
.LP
Gregory R. Andrews and Ronald A. Olsson,
.I "Report on the SR Programming Language, Version 1.1."
TR 89-6, Department of Computer Science,
University of Arizona, May, 1989.
