/*  config.h -- implementation constants, limits, and default values  */


/*  File name configuration  */

#define SOURCE_SUF ".sr"	/* suffix for source file */
#define BODY_SUF ".b"		/* suffix for body file name */
#define INTER_SUF ".i"		/* suffix for interface file name */
#define INTER_DIR "Interfaces"	/* subdirectory for interface information */
#define RUNTIME_OBJ "srlib.o"	/* file name for runtime library */
#define RUNTIME_EXEC "srx"	/* name of runtime executive */


/*  Absolute limits  */

#define MAX_FATALS	  20	/* compilation errs before we abandon ship */
#define MAX_RES_DEF	 100	/* maximum defined (static) resources */
#define MNAME_LENGTH	  32	/* maximum length of a machine name */

#define HOST_NAME_LEN	  64	/* max length of a host name */
#define MAX_PATH	1000	/* maximum path length */
#define MAX_LINE	1000	/* maximum line in directive file */

#define MAX_COLUMNS	  78	/* max output width for srm */
#define TAB_WIDTH	   8	/* assumed width of a \t character */



/*  Runtime limits changeable by srl option.  Additions require changes in:
 *	man/srl.1	(man page)
 *	srl/globals.h	(define variable to hold default)
 *	srl/main.c	(declare variable, accept option, usage message)
 *	srl/gen.c	(generate value for later runtime use)
 *	rts/globals.h	(definition of default value)
 */

#define MAX_CO_STMTS	  40	/* C: default limit on active "co" statements */
#define MAX_LOOPS      10000	/* L: default limit on loops between cswitch */
#define MAX_CLASSES	 100	/* N: default limit on "in" operation classes */
#define MAX_OPERATIONS	1000	/* O: default limit on active operations */
#define MAX_PROCESSES	 300	/* P: default limit on number of processes */
#define MAX_RMT_REQS	  40	/* Q: default limit on pending remote requests*/
#define MAX_RESOURCES	 100	/* R: default limit on active resources */
#define MAX_SEMAPHORES	1000	/* V: default limit on number of semaphores */

#ifdef sparc
#define STACK_SIZE	37000	/* S: default size of a Sun 4 process stack */
#else
#define STACK_SIZE	25000	/* S: default size of a process stack */
#endif
