



# include "strings.h"

procedure readtS{(var f: Text; var s: String; function stop(c:Char):Boolean)};
{
* Reads a string from text file f; eoln or stop(c) returning true
* (whichever occurs first) terminating.  In either case,
* input is left positioned at the terminator.
*
* precondition:
*    f open for reading & not eof(f)
}
	const BufferLength = 120;
	var t : String;
	    i : Nat0; 
	 line : packed array [1..BufferLength] of Char;
begin
	i := 0;
	while not eoln(f) and (i <> BufferLength) and not stop(f^) do begin
		i := i+1;
		read(f, line[i])
	end;
	if i = 0 then assignS(s, nil) else assignS(s, mk(line, i));
	{ --  Check for more characters on the input line }
	if (i = BufferLength) and not stop(f^) and not eoln(f) then begin
		{ --  Get the rest }
		t := nil;
		readtS(f, t, stop);
		assignS(s, concatS(s, t))
	end
end{ -- readtS};
