



# include "strings.h"

procedure readS{(var f: Text; var s: String)};
{
* Reads a string from text file f; eoln terminating.  The input is
* left pointing to the beginning of the next line, if any.
*
* precondition:
*    f open for reading & not eof(f)
}
	const BufferLength = 120;     
	var t : String;
	    i : Nat0; 
	 line : packed array [1..BufferLength] of Char;
	    
begin
	i := 0;
	while not eoln(f) and (i <> BufferLength) do begin
		i := i+1;
		read(f, line[i])
	end;
	if i = 0 then assignS(s, nil) else assignS(s, mk(line, i));
	{ --  Check for more characters on the input line }
	if (i = BufferLength) and not eoln(f) then begin
		{ --  Get the rest }
		t := nil;
		readS(f, t);
		assignS(s, concatS(s, t))
	end;
	if eoln(f) then get(f)
end{ -- readS};
