



# include "strings.h"


function mk{(var static: packed array [lo..hi:Integer] of Char; limit: Integer):String};
{
* Converts a static Pascal string into a (dynamic) String.
* From lo to limit rather than hi.
* This internal procedure may be made generally available
* should there be a demand.
}
   var null: Char;
       StaticLength: Nat1;
       i, ExtraChunks, CurrentLength: Nat0;
       StringHead: String;
       temp: stringtail;
       k: Integer;
       j: 1..slength;
begin
	null := chr(0);
	StaticLength := limit-lo+1;
	ExtraChunks := (StaticLength-1) div slength;
	{ -- Copy into String head }
	new(StringHead);
	with StringHead^ do begin
	    LEN := StaticLength;
	    REFS := 0;
	    TAIL := nil;
	    k := lo;
	    { -- Copy string, null padding if necessary }
	    for j := 1 to slength do
	       if j > StaticLength
	       then HEAD[j] := null
	       else begin
		    HEAD[j] := static[k];
		    k := k+1
	       end;
	    { -- Allocate and link in any extra string chunks needed}
	    for i := 1 to ExtraChunks do begin
	       new(temp); temp^.REST := TAIL; TAIL := temp
	    end;   
	    { -- Loop through copying string tail if required }
	    temp := TAIL;
	    CurrentLength := 0;
	    while temp <> nil do begin
	       with temp^ do begin
			CurrentLength := CurrentLength+slength;
	                { -- Copy string, null padding if necessary }
			for j := 1 to slength do
			   if j+CurrentLength > StaticLength
			   then MORE[j] := null
			   else begin
					MORE[j] := static[k];
					k := k+1
				end
	       end;
	       temp := temp^.REST
	    end{ -- while}
	end{ -- with};
	{ -- Return the newly created dynamic string }
	mk := StringHead
end{ -- mk};
