



# include "strings.h"


function getsubS{(s: String; frompos, topos: Nat0):String};
{
* Returns s[frompos..topos]
* Extracts a substring of s.
*  returns ''  if frompos..topos not in range.
}
   const BufferLength = 512;
   var t: String; j,i, stoppos: Nat1; ch: Char; sp: CharOfString;
       buf: packed array [1..BufferLength] of Char;
begin
	t := nil; { -- empty string }
	if topos <= lengthS(s) then begin
	   { --  convert max(BufferLength) chars to fixed string }
	   if topos-frompos+1 > BufferLength then
		stoppos := frompos+BufferLength-1
	   else
		stoppos := topos;
	   j := 1;
	   first(sp, s);
	   for i := 1 to frompos-1 do next(sp, ch);
	   for i := frompos to stoppos do begin
		next(sp, ch);
		buf[j] := ch;
		j := j+1
	   end{ -- for};
	   { --  convert to String }
	   if j <> 1 then { --  positive slice }
	   	t := mk(buf, j-1);
	   { --  check any more left }
	   if topos <> stoppos then
		t := concatS(t,  getsubS(s, stoppos+1, topos))
	end;
	if s <> nil then if s^.REFS = 0 then disposeS(s);
	getsubS := t
end{ -- getsubS};
