



# include "strings.h"

procedure updateS{(var s: String; i: Nat1; c:Char)};
{
* Updates the string s at position  i  with the char c.
* if i > lengthS(s), s is first space filled upto i-1.
}
   var j: 2..maxint;
       chunk: stringtail;
  
  procedure copy(var lhs: String; rhs: String);
  {
  *  lhs := rhs (forces a string copy)
  }
    var ExtraChunks: Nat0; i: Nat1; temp, l, r: stringtail;
  begin
	new(lhs);
	{ -- Copy string head }
	lhs^ := rhs^;
	with lhs^ do begin
	  REFS := 1;
	  ExtraChunks := (rhs^.LEN-1) div slength;
	  TAIL := nil;
          { -- Allocate and link in any extra string chunks needed }
	  for i := 1 to ExtraChunks do begin
	    new(temp); temp^.REST := TAIL; TAIL := temp
 	  end
 	end;
        { -- Loop through copying string tail if required }
 	l := lhs^.TAIL;  r := rhs^.TAIL;
 	for i := 1 to ExtraChunks do begin
 	   l^.MORE := r^.MORE;
 	   l := l^.REST;
 	   r := r^.REST
 	end
  end{ -- copy};


begin { --  of updateS }
  if s <> nil then
     with s^ do
      if REFS > 1 then begin
	{ -- Make a unique copy before update }
	REFS := REFS-1;	
	copy(s, s) { --  N.B. careful (!) use of var and value params. }
      end;
  if i <= lengthS(s) then
	with s^ do
	  if i <= slength
	  then { -- pos is in string head } HEAD[i] := c
	  else begin
		{ -- find tail chunk containing pos. i }
		chunk := TAIL;
		for j := 2 to (i-1) div slength do
			chunk := chunk^.REST;
		chunk^.MORE[ (i-1) mod slength + 1 ]  := c
	  end
  else { -- Inefficient but rare case }
	assignS(s, concatS(s,concatS(repS(CtoS(' '),i-lengthS(s)-1),CtoS(c))))
end{ -- updateS};
