



# include "strings.h"

function repS{(s: String; n: Nat0):String};
{
* [[ Returns s * n ]]
* Replicates s, n times.
}
  var  null, ChFromS: Char;
       lens, StaticLength: Nat0;
       i, ExtraChunks, CurrentLength: Nat0;
       StringHead: String;
       temp: stringtail;
       k: Integer;
       j: 1..slength;
       sp: CharOfString;
begin
  null := chr(0); lens := lengthS(s); StaticLength := lens*n;
  if StaticLength = 0 then repS := nil { -- emptyS} else begin
	ExtraChunks := (StaticLength-1) div slength;
	{ -- Copy into String head }
	new(StringHead);
	with StringHead^ do begin
	    LEN := StaticLength;
	    REFS := 0;
	    TAIL := nil;
	    first(sp, s); k := 1;
	    { -- Copy string, null padding if necessary }
	    for j := 1 to slength do
	       if j > StaticLength
	       then HEAD[j] := null
	       else begin
		    next(sp, ChFromS);
		    if k = lens then begin
			k := 1; first(sp, s)
		    end else
			k := k+1;
		    HEAD[j] := ChFromS
	       end;
	    { -- Allocate and link in any extra string chunks needed}
	    for i := 1 to ExtraChunks do begin
	       new(temp); temp^.REST := TAIL; TAIL := temp
	    end;   
	    { -- Loop through copying string tail if required }
	    temp := TAIL;
	    CurrentLength := 0;
	    while temp <> nil do begin
	       with temp^ do begin
			CurrentLength := CurrentLength+slength;
	                { -- Copy string, null padding if necessary }
			for j := 1 to slength do
			   if j+CurrentLength > StaticLength
			   then MORE[j] := null
			   else begin
					next(sp, ChFromS);
					if k = lens then begin
					    k := 1; first(sp, s)
					end else
					    k := k+1;
					MORE[j] := ChFromS
				end
	       end;
	       temp := temp^.REST
	    end{ -- while};
    	end{ -- with};
	{ -- Return the newly created dynamic string }
	repS := StringHead
  end;
  if s <> nil then if s^.REFS = 0 then disposeS(s);
end{ -- repS};
