



# include "strings.h"

function concatS{(s1, s2: String):String};
{
* Returns s1 + s2
* Concatenates s1 and s2.
}
   var t: String;  { -- Result is built in t }
       l, r, End1: stringtail;
       StillInHeadOfT, InTailOfT, InTailOfS2: Boolean;
       i, j: Nat1;
       tindx, rindx: 1..slength;
       null: Char;
begin
 t := nil;
 null := chr(0);
 { -- Deal with trivial cases first }
 if s1 = nil then concatS := s2 else
 if s2 = nil then concatS := s1 else
 { -- Both s1 and s2 are non-empty }
  begin
	new(t);
	with t^ do begin
	  LEN := s1^.LEN + s2^.LEN;
	  { -- Copy head of s1 }
	  HEAD := s1^.HEAD;
	  TAIL := nil;
          { -- Allocate and link in any extra string chunks needed }
  	  for i := 1 to (LEN-1) div slength do begin
    		new(l);
		{ -- pad with nulls if chunk is last one }
		if i=1 then
		 for j:=1 to slength do l^.MORE[j] := null;
    		l^.REST := TAIL;
    		TAIL := l
	  end;
          { -- Loop through copying string tail of s1, if required }
	  l := TAIL;  End1 := TAIL; r := s1^.TAIL;
	  for i := 1 to (s1^.LEN-1) div slength  do begin
   		l^.MORE := r^.MORE;
		End1 := l; 
   		l := l^.REST;
   		r := r^.REST
   	  end;
	  { -- End1 points to the last tail entry (partially) filled}
	  if s1^.LEN mod slength <> 0 then l := End1;
	  r := s2^.TAIL;
	  { -- Loop thru copying s2 to end of t char by char! }
	  tindx := s1^.LEN mod slength + 1;
	  rindx := 1; 
	  StillInHeadOfT := s1^.LEN < slength;
	  InTailOfT := false;  InTailOfS2 := false;
	  for i := 1 to s2^.LEN do begin
		if  StillInHeadOfT then begin
		     HEAD[tindx] := s2^.HEAD[rindx];
		     StillInHeadOfT := tindx < slength
		end
		else
		if i <= slength then begin
			InTailOfT := true;
			l^.MORE[tindx] := s2^.HEAD[rindx]
		end
		else begin
			InTailOfS2 := true;
			l^.MORE[tindx] := r^.MORE[rindx]
		end;
		{ -- Always inc indices and step down lists if req. }
		tindx := tindx mod slength + 1;
		if (tindx = 1) and InTailOfT  then l := l^.REST;
		rindx := rindx mod slength + 1;
		if (rindx = 1) and InTailOfS2 then r := r^.REST
	  end
  	end{ -- with};
	{ -- Make 0 ref count }
	t^.REFS := 0;
	{ -- Tidy up any intermediate storage }
	if s1 <> nil then if s1^.REFS = 0 then disposeS(s1);
	if s2 <> nil then if s2^.REFS = 0 then disposeS(s2);
	concatS := t
 end
end{ -- concatS};
