



# include "strings.h"

function compare{(left, right: String):StrCmpResult};
   var lenl, lenr: Nat0;  ltail, rtail: stringtail;
       state: (GoOn, Less, Greater, Stop);
begin
  lenl  := lengthS(left); lenr  := lengthS(right);
  { -- Do trivial cases first }
  if lenl = 0 then
	if lenr = 0 then compare := eq else compare := lt
  else	if lenr = 0 then compare := gt else begin
   { -- Non-trivial cases - both left and right are non empty }
   ltail := left^.TAIL;    rtail := right^.TAIL;
   if left^.HEAD < right^.HEAD then state := Less else
   if left^.HEAD > right^.HEAD then state := Greater else
   if (ltail = nil) or (rtail = nil)
   then state := Stop
   else state := GoOn;
   { -- Check tails if necessary }
   while state = GoOn do
	if ltail^.MORE < rtail^.MORE then state := Less else
	if ltail^.MORE > rtail^.MORE then state := Greater else
	if (ltail^.REST = nil) or (rtail^.REST = nil)
	then state := Stop
	else
	 begin ltail := ltail^.REST; rtail := rtail^.REST end;
   { -- Final check for differing lengths (etc.) }
   case state of
	Less:	 compare := lt;
	Greater: compare := gt;
	Stop:	 if lenl < lenr then compare := lt else
		 if lenl > lenr then compare := gt
		 else compare := eq
   end
  end;
  { -- comparison may have involved constant strings }
  if left  <> nil then if  left^.REFS = 0 then disposeS(left);
  if right <> nil then if right^.REFS = 0 then disposeS(right)
end{ -- compare};
