#include "../h/rt.h"

/*
 * add, sub, mul, neg with overflow check
 * all return 1 if ok, 0 if would overflow
 */

word add3 (a, b, c)
    word a, b, *c;
{
    if ((a ^ b) >= 0
	&& (a >= 0 ? b > MaxLong - a : b < MinLong - a)) return 0;
    *c = a + b;
    return 1;
}

word sub3 (a, b, c)
    word a, b, *c;
{
    if ((a ^ b) < 0
	&& (a >= 0 ? b < a - MaxLong : b > a - MinLong)) return 0;
    *c = a - b;
    return 1;
}

word mul3 (a, b, c)
    word a, b, *c;
{
    if (b != 0) {
	if ((a ^ b) >= 0) {
	    if (a >= 0 ? a > MaxLong / b : a < MaxLong / b) return 0;}
	else if (b != -1) {
	    if (a >= 0 ? a > MinLong / b : a < MinLong / b) return 0;}}

    *c = a * b;
    return 1;
}

/* MinLong / -1 overflows; need div3 too */

word neg2 (a, c)
    word a, *c;
{
    if (a == MinLong) return 0;
    *c = -a;
    return 1;
}
