extern struct descrip *itobigl();
extern double bigtoreal();
/*
 * File: oarith.c
 *  Contents: divide, minus, mod, mult, neg, number, plus, power
 */

#include "../h/rt.h"
#ifdef SUN
#include <math.h>
#include <signal.h>
#endif					/* SUN */

#ifdef NoOver
#define Add(x,y) (x + y)
#define Sub(x,y) (x - y)
#define Mpy(x,y) (x * y)
#else					/* NoOver */
#define Add(x,y) ckadd(x,y)
#define Sub(x,y) cksub(x,y)
#define Mpy(x,y) ckmul(x,y)
#endif					/* NoOver */

#define Abs(x) ((x) > 0 ? (x) : -(x))

/*
 * x / y - divide y into x.
 */

OpDcl(divide,2,"/")
   {
   register int t1, t2;
   union numeric n1, n2;

   /*
    * Arg1 and Arg2 must be numeric.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail)
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Arg1 and Arg2 are both integers, just divide them and return the
       * result.
       */
       int val;

      if (n2.integer == 0L) 
         RunErr(201, &Arg2);

       MkIntT(n1.integer / n2.integer, &Arg0)
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either Arg1 or Arg2 or both is real, convert the real values to
       *  integers, divide them, and return the result.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);

#ifdef ZeroDivide
      if (n2.real == 0.0) 
         RunErr(-204, NULL);
#endif					/* ZeroDivide */

      if (mkreal(n1.real / n2.real, &Arg0) == Error) 
         RunErr(0, NULL);

#ifdef SUN
      if (((struct b_real *)BlkLoc(Arg0))->realval == HUGE)
         kill(getpid(),SIGFPE);
#endif					/* SUN */

      }
   else {
       if (t1 == T_Integer) { 
	   bigdiv (itobigl (n1.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigdivi (&Arg1, n2.integer, &Arg0);} 
       else {
	   bigdiv (&Arg1, &Arg2, &Arg0);}}

   Return;
   }


/*
 * x - y - subtract y from x.
 */

OpDcl(minus,2,"-")
   {
   register int t1, t2;
   union numeric n1, n2;

#ifndef NoOver
   extern long cksub();
#endif					/* NoOver */

   /*
    * x and y must be numeric.  Save the cvnum return values for later use.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail) 
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Both x and y are integers.  Perform integer subtraction and place
       *  the result in Arg0 as the return value.
       */
       if (sub3 (n1.integer, n2.integer, &IntVal(Arg0)))
	   Arg0.dword = D_Integer;
       else
	   bigsubi (itobigl (n1.integer), n2.integer, &Arg0);
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either x or y is real, convert the other to a real, perform
       *  the subtraction and place the result in Arg0 as the return value.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);

      if (mkreal(n1.real - n2.real, &Arg0) == Error) 
         RunErr(0, NULL);

      }
   else {
       if (t1 == T_Integer) {
	   bigsub (itobigl (n1.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigsubi (&Arg1, n2.integer, &Arg0);}
       else {
	   bigsub (&Arg1, &Arg2, &Arg0);}}
   Return;
   }

/*
 * x % y - take remainder of x / y.
 */

OpDcl(mod,2,"%")
   {
   register int t1, t2;
   union numeric n1, n2;
   long int_rslt;
   double real_rslt;

   /*
    * x and y must be numeric.  Save the cvnum return values for later use.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail) 
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Both x and y are integers.  If y is 0, generate an error because
       *  it's divide by 0.  Otherwise, just return the modulus of the
       *  two arguments.
       */
      if (n2.integer == 0L) 
         RunErr(202, &Arg2);
      int_rslt = n1.integer % n2.integer;
      /*
       * The sign of the result must match that of n1.
       */
      if (n1.integer < 0) {
         if (int_rslt > 0)
            int_rslt -= Abs(n2.integer);
         }
      else if (int_rslt < 0)
         int_rslt += Abs(n2.integer);
      MkIntT(int_rslt, &Arg0)
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either x or y is real, convert the other to a real, perform
       *  the modulation, convert the result to an integer and place it
       *  in Arg0 as the return value.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);
      real_rslt = n1.real - n2.real * (int)(n1.real / n2.real);
      /*
       * The sign of the result must match that of n1.
       */
      if (n1.real < 0.0) {
         if (real_rslt > 0.0)
            real_rslt -= Abs(n2.real);
         }
      else if (real_rslt < 0.0)
         real_rslt += Abs(n2.real);
      if (mkreal(real_rslt, &Arg0) == Error) 
         RunErr(0, NULL);
      }
   else {
       if (t1 == T_Integer) {
	   bigmod (itobigl (n1.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigmodi (&Arg1, n2.integer, &Arg0);}
       else {
	   bigmod (&Arg1, &Arg2, &Arg0);}}

   Return;
   }


/*
 * x * y - multiply x and y.
 */

OpDcl(mult,2,"*")
   {
   register int t1, t2;
   union numeric n1, n2;

#ifndef NoOver
   extern long ckmul();
#endif					/* NoOver */

   /*
    * Arg1 and Arg2 must be numeric.  Save the cvnum return values for later
    *  use.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail) 
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Both Arg1 and Arg2 are integers.  Perform the multiplication and
       *  and place the result in Arg0 as the return value.
       */
       if (mul3 (n1.integer, n2.integer, &IntVal(Arg0)))
	   Arg0.dword = D_Integer;
       else
	   bigmuli (itobigl (n1.integer), n2.integer, &Arg0);
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either Arg1 or Arg2 is real, convert the other to a real, perform
       *  the subtraction and place the result in Arg0 as the return value.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);
      if (mkreal(n1.real * n2.real, &Arg0) == Error) 
         RunErr(0, NULL);
      }
   else {
       if (t1 == T_Integer) {
	   bigmuli (&Arg2, n1.integer, &Arg0);}
       else if (t2 == T_Integer) {
	   bigmuli (&Arg1, n2.integer, &Arg0);} 
       else {
	   bigmul (&Arg1, &Arg2, &Arg0);}}

   Return;
   }

/*
 * -x - negate x.
 */

OpDcl(neg,1,"-")
   {
   union numeric n;
   long l;

   /*
    * Arg1 must be numeric.
    */
   switch (cvnum(&Arg1, &n)) {

      case T_Integer:
         /*
          * If Arg1 is an integer, negate it and check for overflow.
	  * Use MkInt to construct the return value.
          */
	 if (neg2 (n.integer, &l))
	     {MkIntT(l, &Arg0);}
	 else {
	     bignegi (n.integer, &Arg0);}
         break;

      case T_Real:
         /*
          * Arg1 is real, just negate it and use mkreal to construct the
          *  return value.
          */

#ifdef RTACIS
         { 
         double rtbug_temporary;		/* bug with "-" as parameter */
         rtbug_temporary = -n.real;
         if (mkreal( rtbug_temporary , &Arg0) == Error) 
            RunErr(0, NULL);
         }
#else					/* RTACIS */
         if (mkreal(-n.real, &Arg0) == Error) 
            RunErr(0, NULL);
#endif					/* RTACIS */

         break;

     case T_Bignum:
	 cpbignum (&Arg1, &Arg0);
	 BlkLoc(Arg0)->bignumblk.sign ^= 1;
	 break;

      default:
         /*
          * Arg1 is not numeric.
          */
         RunErr(102, &Arg1);
      }
   Return;
   }

/*
 * +x - convert x to numeric type.
 *  Operational definition: generate runerr if x is not numeric.
 */

OpDcl(number,1,"+")
   {
   union numeric n;

   switch (cvnum(&Arg1, &n)) {

      case T_Integer:
         MkIntT(n.integer, &Arg0);
         break;

      case T_Real:
         if (mkreal(n.real, &Arg0) == Error) 
            RunErr(0, NULL);
         break;

     case T_Bignum:
	 mkbignum (n.bptr, &Arg0);
	 break;

      default:
         RunErr(102, &Arg1);
      }
   Return;
   }

/*
 * x + y - add x and y.
 */

OpDcl(plus,2,"+")
   {
   register int t1, t2;
   union numeric n1, n2;

#ifndef NoOver
   extern long ckadd();
#endif					/* NoOver */

   /*
    * Arg1 and Arg2 must be numeric.  Save the cvnum return values for later
    *  use.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail) 
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Both Arg1 and Arg2 are integers.  Perform integer addition and plcae
       *  the result in Arg0 as the return value.
       */
       if (add3 (n1.integer, n2.integer, &IntVal(Arg0)))
	   Arg0.dword = D_Integer;
       else
	   bigaddi (itobigl (n1.integer), n2.integer, &Arg0);
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either Arg1 or Arg2 is real, convert the other to a real, perform
       *  the addition and place the result in Arg0 as the return value.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);
      if (mkreal(n1.real + n2.real, &Arg0) == Error) 
         RunErr(0, NULL);
      }
   else {
       if (t1 == T_Integer) {
	   bigaddi (&Arg2, n1.integer, &Arg0);}
       else if (t2 == T_Integer) {
	   bigaddi (&Arg1, n2.integer, &Arg0);}
       else {
	   bigadd (&Arg1, &Arg2, &Arg0);}}

   Return;
   }

/*
 * x ^ y - raise x to the y power.
 */

OpDcl(power,2,"^")
   {
   register int t1, t2;
   union numeric n1, n2;
   extern double pow();
   extern long ipow();

   /*
    * Arg1 and Arg2 must be numeric.  Save the cvnum return values for later
    *  use.
    */
   if ((t1 = cvnum(&Arg1, &n1)) == CvtFail) 
      RunErr(102, &Arg1);
   if ((t2 = cvnum(&Arg2, &n2)) == CvtFail) 
      RunErr(102, &Arg2);

   if (t1 == T_Integer && t2 == T_Integer) {
      /*
       * Both Arg1 and Arg2 are integers.  Perform integer exponentiation
       *  and place the result in Arg0 as the return value.
       */
       bigpowii (n1.integer, n2.integer, &Arg0);
      }
   else if (t1 == T_Real || t2 == T_Real) {
      /*
       * Either x or y is real, convert the other to a real, perform
       *  real exponentiation and place the result in Arg0 as the
       *  return value.
       */
       if (t1 != T_Real)
	   if (t1 != T_Bignum) n1.real = n1.integer;
	   else n1.real = bigtoreal (n1.bptr);
       if (t2 != T_Real)
	   if (t2 != T_Bignum) n2.real = n2.integer;
	   else n2.real = bigtoreal (n2.bptr);
      if (n1.real == 0.0 && n2.real <= 0.0) 
         /*
          * Tried to raise zero to a negative power.
          */
         RunErr(-204, NULL);
      if (n1.real < 0.0 && t2 == T_Real) 
         /*
          * Tried to raise a negative number to a real power.
          */
         RunErr(-206, NULL);

#ifdef RTACIS
      {
       double rtbug_temporary;			/* bug in pow routine for negative x */

       if ((n1.real < 0.0) && /* integral? */ (((double)((long int)
          n2.real)) == n2.real)) 
            {
            rtbug_temporary = -n1.real; 
            rtbug_temporary = -pow(rtbug_temporary,n2.real);
            } 
            else rtbug_temporary = pow(n1.real,n2.real);
       if (mkreal(rtbug_temporary, &Arg0) == Error) 
          RunErr(0, NULL);
       }
#else					/* RTACIS */
       if (mkreal(pow(n1.real,n2.real), &Arg0) == Error) 
          RunErr(0, NULL);
#endif					/* RTACIS */

      }
   else {
       if (t1 == T_Integer) {
	   bigpowii (n1.integer, (long) bigtoreal (n2.bptr), &Arg0);}
       else if (t2 == T_Integer) {
	   bigpowi (&Arg1, n2.integer, &Arg0);}
       else {
	   bigpow (&Arg1, &Arg2, &Arg0);}}

   Return;
   }

#if 0
long ipow(n1, n2)
long n1, n2;
   {
   long result;

   if (n1 == 0 && n2 <= 0) 
      RunErr(-204, NULL);		/* can't recover from this place */
   if (n2 < 0)
      return 0.0;
   result = 1L;
   while (n2 > 0) {
      if (n2 & 01L)
         result *= n1;
      n1 *= n1;
      n2 >>= 1;
      }
   return result;
   }
#endif
